/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.utils.ReflectionUtils;
import org.bardframework.commons.web.utils.WebUtils;
import org.bardframework.flow.FlowData;
import org.bardframework.flow.FlowHandler;
import org.bardframework.flow.FlowResponse;
import org.bardframework.flow.exception.FlowDataValidationException;
import org.bardframework.flow.exception.InvalidateFlowException;
import org.bardframework.flow.form.FlowFormTemplate;
import org.bardframework.flow.form.FormProcessor;
import org.bardframework.flow.form.field.input.FlowInputFieldTemplate;
import org.bardframework.flow.repository.FlowDataRepository;
import org.bardframework.form.BardForm;
import org.bardframework.form.FormTemplate;
import org.bardframework.form.FormUtils;
import org.bardframework.form.field.input.InputFieldTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlowHandlerAbstract<D extends FlowData>
implements FlowHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final FlowDataRepository<D> flowDataRepository;
    protected final List<FlowFormTemplate> forms;
    protected List<FormProcessor> preProcessors = new ArrayList<FormProcessor>();
    protected List<FormProcessor> postProcessors = new ArrayList<FormProcessor>();
    protected Map<String, List<FormProcessor>> actionProcessors = new HashMap<String, List<FormProcessor>>();

    public FlowHandlerAbstract(FlowDataRepository<D> flowDataRepository, List<FlowFormTemplate> forms) {
        this.flowDataRepository = flowDataRepository;
        this.forms = forms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowResponse start(Map<String, String> initValues, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowData flowData = (FlowData)ReflectionUtils.newInstance((Class)ReflectionUtils.getGenericArgType(this.getClass(), (int)0));
        String flowToken = this.generateFlowToken();
        flowData.setLocale(locale);
        flowData.getData().putAll(initValues);
        flowData.setCurrentFormIndex(-1);
        this.getFlowDataRepository().put(flowToken, flowData);
        try {
            this.process(this.getPreProcessors(flowData), flowToken, flowData, Map.of(), httpRequest, httpResponse);
            FlowResponse flowResponse = this.processNextForm(flowToken, flowData, Map.of(), httpRequest, httpResponse);
            return flowResponse;
        }
        finally {
            this.updateFlowData(flowToken, flowData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowResponse submit(String flowToken, Map<String, String> formData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowData flowData = (FlowData)this.getFlowDataRepository().get(flowToken);
        FlowFormTemplate currentFormTemplate = this.getCurrentFormTemplate(flowData);
        currentFormTemplate.validate(flowToken, flowData.getData(), formData, flowData.getLocale());
        this.fillFlowData(flowData.getData(), formData, currentFormTemplate);
        try {
            this.process(currentFormTemplate.getPostProcessors(), flowToken, flowData, formData, httpRequest, httpResponse);
            FlowResponse flowResponse = this.processNextForm(flowToken, flowData, formData, httpRequest, httpResponse);
            return flowResponse;
        }
        catch (Exception ex) {
            FlowResponse flowResponse = this.handleSubmitException(flowToken, flowData, formData, currentFormTemplate, ex);
            return flowResponse;
        }
        finally {
            this.updateFlowData(flowToken, flowData);
        }
    }

    @Override
    public void action(String flowToken, String action, Map<String, String> formData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        this.log.debug("start action[{}] processing, flow token [{}], form data [{}]", new Object[]{action, flowToken, formData});
        FlowData flowData = (FlowData)this.getFlowDataRepository().get(flowToken);
        FlowFormTemplate currentFormTemplate = this.getCurrentFormTemplate(flowData);
        if (StringUtils.isBlank((CharSequence)action)) {
            this.log.warn("null action can't process, flow token [{}], form [{}]", (Object)flowToken, (Object)currentFormTemplate.getName());
            httpResponse.setStatus(404);
            return;
        }
        try {
            if (!this.processAction(flowToken, action, flowData, formData, currentFormTemplate, httpRequest, httpResponse)) {
                this.log.warn("no processor exist to handle action [{}], flow token [{}], form [{}]", new Object[]{action, flowToken, currentFormTemplate.getName()});
                throw new InvalidateFlowException(flowToken, "invalid action");
            }
        }
        catch (InvalidateFlowException ex) {
            this.invalidateFlow(ex);
            throw ex;
        }
        finally {
            this.updateFlowData(flowToken, flowData);
        }
    }

    @Override
    public FlowResponse getCurrent(String flowToken, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowData flowData = (FlowData)this.getFlowDataRepository().get(flowToken);
        if (flowData.getCurrentFormIndex() == 0) {
            flowData.setLocale(locale);
            this.updateFlowData(flowToken, flowData);
        }
        FlowFormTemplate currentFormTemplate = this.getCurrentFormTemplate(flowData);
        return this.toResponse(flowToken, currentFormTemplate, flowData, httpRequest, httpResponse);
    }

    protected boolean processAction(String flowToken, String action, D flowData, Map<String, String> formData, FlowFormTemplate currentFormTemplate, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        for (FlowInputFieldTemplate fieldTemplate : currentFormTemplate.getFieldTemplates(((FlowData)flowData).getData(), FlowInputFieldTemplate.class)) {
            if (!this.process(fieldTemplate.getActionProcessors().get(action), flowToken, flowData, formData, httpRequest, httpResponse)) continue;
            return true;
        }
        if (this.process(currentFormTemplate.getActionProcessors().get(action), flowToken, flowData, formData, httpRequest, httpResponse)) {
            return true;
        }
        return this.process(this.getActionProcessors(flowData).get(action), flowToken, flowData, formData, httpRequest, httpResponse);
    }

    protected void fillFlowData(Map<String, String> flowData, Map<String, String> formData, FlowFormTemplate currentFormTemplate) {
        for (InputFieldTemplate inputFieldTemplate : currentFormTemplate.getFieldTemplates(flowData, InputFieldTemplate.class)) {
            String value;
            if (!inputFieldTemplate.isPersistentValue() || !StringUtils.isNotBlank((CharSequence)(value = formData.remove(inputFieldTemplate.getName())))) continue;
            flowData.put(inputFieldTemplate.getName(), WebUtils.escapeString((String)value));
        }
    }

    protected FlowResponse processNextForm(String flowToken, D flowData, Map<String, String> formData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowResponse response;
        FlowFormTemplate nextFormTemplate = this.forms.subList(((FlowData)flowData).getCurrentFormIndex() + 1, this.forms.size()).stream().filter(formTemplate -> formTemplate.mustShow(flowData.getData())).findFirst().orElse(null);
        if (null != nextFormTemplate) {
            this.process(nextFormTemplate.getPreProcessors(), flowToken, flowData, formData, httpRequest, httpResponse);
            for (FlowInputFieldTemplate flowInputFieldTemplate : nextFormTemplate.getFieldTemplates(formData, FlowInputFieldTemplate.class)) {
                flowInputFieldTemplate.preProcess(flowToken, ((FlowData)flowData).getData(), ((FlowData)flowData).getLocale(), httpResponse);
            }
            ((FlowData)flowData).setCurrentFormIndex(this.forms.indexOf((Object)nextFormTemplate));
        }
        if (Boolean.TRUE.equals((response = this.toResponse(flowToken, nextFormTemplate, flowData, httpRequest, httpResponse)).getFinished())) {
            this.onFinished(flowToken, flowData, formData, httpRequest, httpResponse);
        }
        return response;
    }

    protected FlowFormTemplate getCurrentFormTemplate(D flowData) throws Exception {
        return this.forms.get(((FlowData)flowData).getCurrentFormIndex());
    }

    protected void onFinished(String flowToken, D flowData, Map<String, String> formData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        this.process(this.getPostProcessors(flowData), flowToken, flowData, formData, httpRequest, httpResponse);
        this.cleanFlowData(flowToken);
    }

    protected void updateFlowData(String flowToken, D flowData) {
        if (this.getFlowDataRepository().contains(flowToken)) {
            this.getFlowDataRepository().put(flowToken, flowData);
        }
    }

    protected void invalidateFlow(InvalidateFlowException ex) {
        this.cleanFlowData(ex.getFlowToken());
    }

    protected FlowResponse toResponse(String flowToken, FlowFormTemplate formTemplate, D flowData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowResponse response = new FlowResponse();
        if (null != formTemplate) {
            BardForm nextForm = FormUtils.toForm((FormTemplate)formTemplate, ((FlowData)flowData).getData(), ((FlowData)flowData).getData(), (Locale)((FlowData)flowData).getLocale());
            response.setForm(nextForm).setSteps(this.getStepsCounts(flowData)).setCurrent(((FlowData)flowData).getCurrentFormIndex());
        }
        if (null == formTemplate || formTemplate.isFinished()) {
            response.setFinished(Boolean.TRUE);
        } else {
            httpResponse.setHeader("X-Flow-Token", flowToken);
        }
        return response;
    }

    protected FlowResponse handleSubmitException(String flowToken, D flowData, Map<String, String> formData, FlowFormTemplate currentFormTemplate, Exception ex) throws Exception {
        FlowDataValidationException e;
        if (ex instanceof InvalidateFlowException) {
            InvalidateFlowException e2 = (InvalidateFlowException)ex;
            this.invalidateFlow(e2);
        } else if (ex instanceof FlowDataValidationException && (e = (FlowDataValidationException)ex).isSendCurrentForm()) {
            e.setForm(FormUtils.toForm((FormTemplate)currentFormTemplate, ((FlowData)flowData).getData(), ((FlowData)flowData).getData(), (Locale)((FlowData)flowData).getLocale()));
        }
        return this.handleException(flowToken, flowData, formData, currentFormTemplate, ex);
    }

    protected abstract FlowResponse handleException(String var1, D var2, Map<String, String> var3, FlowFormTemplate var4, Exception var5) throws Exception;

    protected int getStepsCounts(D flowData) {
        return this.forms.size();
    }

    protected void cleanFlowData(String flowToken) {
        this.getFlowDataRepository().remove(flowToken);
    }

    protected boolean process(List<FormProcessor> processors, String flowToken, D flowData, Map<String, String> formData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        if (CollectionUtils.isEmpty(processors)) {
            return false;
        }
        List executableProcessors = processors.stream().filter(formProcessor -> formProcessor.mustExecute(flowData.getData())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(executableProcessors)) {
            return false;
        }
        for (FormProcessor processor : executableProcessors) {
            processor.process(flowToken, ((FlowData)flowData).getData(), formData, ((FlowData)flowData).getLocale(), httpRequest, httpResponse);
        }
        return true;
    }

    public List<FormProcessor> getPreProcessors(D flowData) {
        return this.preProcessors;
    }

    public void setPreProcessors(List<FormProcessor> preProcessors) {
        this.preProcessors = preProcessors;
    }

    public List<FormProcessor> getPostProcessors(D flowData) {
        return this.postProcessors;
    }

    public void setPostProcessors(List<FormProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    public Map<String, List<FormProcessor>> getActionProcessors(D flowData) {
        return this.actionProcessors;
    }

    public void setActionProcessors(Map<String, List<FormProcessor>> actionProcessors) {
        this.actionProcessors = actionProcessors;
    }

    public Logger getLog() {
        return this.log;
    }

    public FlowDataRepository<D> getFlowDataRepository() {
        return this.flowDataRepository;
    }

    public List<FlowFormTemplate> getForms() {
        return this.forms;
    }

    public List<FormProcessor> getPreProcessors() {
        return this.preProcessors;
    }

    public List<FormProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public Map<String, List<FormProcessor>> getActionProcessors() {
        return this.actionProcessors;
    }
}

