/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.table;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.bardframework.commons.web.WebTestHelper;
import org.bardframework.crud.api.base.BaseCriteria;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.ServiceDataProvider;
import org.bardframework.crud.api.common.TestUtils;
import org.bardframework.table.TableData;
import org.bardframework.table.TableModeCheckUtils;
import org.bardframework.table.TableModel;
import org.bardframework.table.TableModelRestController;
import org.junit.jupiter.api.Test;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;

public interface TableModelRestControllerTest<L extends TableModelRestController<?, ?, ?, ?>, M extends BaseModel<I>, C extends BaseCriteria<I>, P extends ServiceDataProvider<M, C, ?, ?, ?, I, U>, I, U>
extends WebTestHelper {
    public L getController();

    public P getDataProvider();

    public List<Locale> getLocales();

    public String BASE_URL();

    default public String TABLE_GET_URL() {
        return this.BASE_URL() + "/table";
    }

    default public String TABLE_FILTER_URL() {
        return this.BASE_URL() + "/table/filter";
    }

    default public String TABLE_EXPORT_URL() {
        return this.BASE_URL() + "/table/export";
    }

    default public String makeUrl(String url, C criteria, Pageable pageable) throws ReflectiveOperationException {
        return String.format("%s?page=%d&size=%d&%s", url, pageable.getPageNumber(), pageable.getPageSize(), TestUtils.toQueryParam(criteria));
    }

    @Test
    default public void testTableGet() throws Exception {
        MockHttpServletRequestBuilder request = MockMvcRequestBuilders.get((String)this.TABLE_GET_URL(), (Object[])new Object[0]);
        TableModel tableModel = (TableModel)this.execute(request, HttpStatus.OK, TableModel.class);
        Assertions.assertThat((Object)tableModel).isNotNull();
        Assertions.assertThat((List)tableModel.getHeaders()).isNotEmpty();
    }

    @Test
    default public void testTableDataGet() throws Exception {
        Object user = this.getDataProvider().getUser();
        BaseModel model = this.getDataProvider().getModel(user);
        BaseCriteria criteria = this.getDataProvider().getFilterCriteria(List.of(model));
        Pageable pageable = this.getDataProvider().getPageable();
        String url = this.makeUrl(this.TABLE_FILTER_URL(), criteria, pageable);
        MockHttpServletRequestBuilder request = MockMvcRequestBuilders.get((String)url, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON);
        TableData tableData = (TableData)this.execute(request, HttpStatus.OK, TableData.class);
        ((ListAssert)Assertions.assertThat((List)tableData.getHeaders()).isNotNull()).isNotEmpty();
        ((ListAssert)Assertions.assertThat((List)tableData.getData()).isNotNull()).isNotEmpty();
        Assertions.assertThat((long)tableData.getTotal()).isGreaterThan(0L);
    }

    @Test
    default public void testTableDataExport() throws Exception {
        Object user = this.getDataProvider().getUser();
        BaseModel model = this.getDataProvider().getModel(user);
        BaseCriteria criteria = this.getDataProvider().getFilterCriteria(List.of(model));
        Pageable pageable = this.getDataProvider().getPageable();
        String url = this.makeUrl(this.TABLE_EXPORT_URL(), criteria, pageable);
        MockHttpServletRequestBuilder request = MockMvcRequestBuilders.get((String)url, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).accept(new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"});
        MvcResult result = this.execute(request);
        Assertions.assertThat((int)result.getResponse().getStatus()).isEqualTo(HttpStatus.OK.value());
    }

    @Test
    default public void checkTableModelI18n() {
        for (Locale locale : this.getLocales()) {
            List<String> notExistKeys = TableModeCheckUtils.checkI18nExistence(this.getController().getTableTemplate(), Map.of(), locale);
            ((ListAssert)Assertions.assertThat(notExistKeys).withFailMessage("these message translation not found in lang <%s>:\n<%s>\n", new Object[]{String.join((CharSequence)"\n", notExistKeys), locale})).isEmpty();
        }
    }

    @Test
    default public void checkTableDefinitionValidity() {
        for (Locale locale : this.getLocales()) {
            TableModeCheckUtils.checkDefinitionValidity(this.getController().getTableTemplate(), Map.of(), locale);
        }
    }
}

