/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.api.common;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.bardframework.commons.utils.ReflectionUtils;
import org.bardframework.crud.api.base.BaseCriteria;
import org.bardframework.form.model.filter.Filter;
import org.bardframework.form.model.filter.RangeFilter;
import org.bardframework.form.model.filter.StringFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestUtils.class);

    public static <C extends BaseCriteria<?>> String toQueryParam(C criteria) throws ReflectiveOperationException {
        if (null == criteria) {
            return "";
        }
        ArrayList<String> params = new ArrayList<String>();
        for (Field field : criteria.getClass().getDeclaredFields()) {
            Object value = ReflectionUtils.getPropertyValue(criteria, (String)field.getName());
            if (value instanceof Filter) {
                Filter filter = (Filter)value;
                params.addAll(TestUtils.toQueryParam(filter, field.getName()));
            }
            if (value instanceof RangeFilter) {
                RangeFilter rangeFilter = (RangeFilter)value;
                params.addAll(TestUtils.toQueryParam(rangeFilter, field.getName()));
            }
            if (!(value instanceof StringFilter)) continue;
            StringFilter stringFilter = (StringFilter)value;
            params.addAll(TestUtils.toQueryParam(stringFilter, field.getName()));
        }
        return String.join((CharSequence)"&", params);
    }

    public static List<String> toQueryParam(StringFilter filter, String name) {
        if (null == filter) {
            return Collections.emptyList();
        }
        ArrayList<String> params = new ArrayList<String>();
        if (null != filter.getContains()) {
            params.add("%s.contains=%s".formatted(name, filter.getEquals()));
        }
        if (null != filter.getDoesNotContain()) {
            params.add("%s.doesNotContain=%s".formatted(name, filter.getEquals()));
        }
        if (null != filter.getStartWith()) {
            params.add("%s.startWith=%s".formatted(name, filter.getEquals()));
        }
        if (null != filter.getEndWith()) {
            params.add("%s.endWith=%s".formatted(name, filter.getEquals()));
        }
        return params;
    }

    public static List<String> toQueryParam(RangeFilter<?, ?> filter, String name) {
        if (null == filter) {
            return Collections.emptyList();
        }
        ArrayList<String> params = new ArrayList<String>();
        if (null != filter.getFrom()) {
            params.add("%s.from=%s".formatted(name, filter.getEquals()));
        }
        if (null != filter.getTo()) {
            params.add("%s.to=%s".formatted(name, filter.getEquals()));
        }
        return params;
    }

    public static List<String> toQueryParam(Filter<?, ?> filter, String name) {
        if (null == filter) {
            return Collections.emptyList();
        }
        ArrayList<String> params = new ArrayList<String>();
        if (null != filter.getEquals()) {
            params.add("%s.equals=%s".formatted(name, filter.getEquals()));
        }
        if (null != filter.getNotEquals()) {
            params.add("%s.notEquals=%s".formatted(name, filter.getNotEquals()));
        }
        if (null != filter.getSpecified()) {
            params.add("%s.specified=%s".formatted(name, filter.getSpecified()));
        }
        if (null != filter.getIn()) {
            for (Object id : filter.getIn()) {
                params.add("%s.in=%s".formatted(name, id));
            }
        }
        if (null != filter.getNotIn()) {
            for (Object id : filter.getNotIn()) {
                params.add("%s.notIn=%s".formatted(name, id));
            }
        }
        return params;
    }

    @Generated
    private TestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

