/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.api.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.bardframework.crud.api.base.BaseCriteria;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.BaseRepository;
import org.bardframework.crud.api.base.PagedData;
import org.bardframework.crud.api.base.RepositoryDataProvider;
import org.bardframework.form.model.filter.IdFilter;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public interface BaseRepositoryTest<M extends BaseModel<I>, C extends BaseCriteria<I>, R extends BaseRepository<M, C, I, U>, P extends RepositoryDataProvider<M, C, R, I, U>, I, U> {
    public R getRepository();

    public P getDataProvider();

    @Test
    default public void testGetByIdValid() {
        Object user = this.getDataProvider().getUser();
        Object id = this.getDataProvider().getId(user);
        LoggerFactory.getLogger(this.getClass()).debug("test get by id '{}'.", id);
        BaseModel result = this.getRepository().get(id, user);
        LoggerFactory.getLogger(this.getClass()).debug("get by id '{}', result is '{}'.", id, (Object)result);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat(id).isEqualTo(result.getId());
    }

    @Test
    default public void testGetByIdInvalid() {
        Object user = this.getDataProvider().getUser();
        Object invalidId = this.getDataProvider().getInvalidId();
        LoggerFactory.getLogger(this.getClass()).debug("test get by invalid id '{}'.", invalidId);
        BaseModel result = this.getRepository().get(invalidId, user);
        LoggerFactory.getLogger(this.getClass()).debug("get by invalid id '{}', result is '{}'.", invalidId, (Object)result);
        Assertions.assertThat((Object)result).isNull();
    }

    @Test
    default public void testGetByIdNull() {
        LoggerFactory.getLogger(this.getClass()).debug("test get by null id'.");
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> {
            BaseModel result = this.getRepository().get(null, user);
            LoggerFactory.getLogger(this.getClass()).error("get by null id, expect exception but result is '{}'.", (Object)result);
        });
    }

    @Test
    default public void testGetByIdsDuplicate() {
        Object user = this.getDataProvider().getUser();
        Object id = this.getDataProvider().getId(user);
        List duplicateIds = List.of(id, id, id, id, id);
        LoggerFactory.getLogger(this.getClass()).debug("test get by duplicate ids '{}'.", duplicateIds);
        List result = this.getRepository().get(duplicateIds, user);
        LoggerFactory.getLogger(this.getClass()).debug("get by duplicate ids '{}', result  is '{}'.", duplicateIds, (Object)result);
        ((ListAssert)Assertions.assertThat((List)result).hasSize(1)).map(BaseModel::getId).containsOnly(new Object[]{id});
    }

    @Test
    default public void testGetByIdsNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> {
            List result = this.getRepository().get((Collection)null, user);
            LoggerFactory.getLogger(this.getClass()).error("get by null ids, expect exception but result is'{}'.", (Object)result);
        });
    }

    @Test
    default public void testGetByIdsEmpty() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatThrownBy(() -> this.getRepository().get(List.of(), user));
    }

    @Test
    default public void testGetByCriteria() {
        Object user = this.getDataProvider().getUser();
        Object model = this.getDataProvider().getModel(user);
        Object criteria = this.getDataProvider().getEmptyCriteria();
        criteria.setIdFilter((IdFilter)new IdFilter().setEquals(model.getId()));
        LoggerFactory.getLogger(this.getClass()).debug("get by criteria '{}'.", criteria);
        BaseModel result = this.getRepository().getOne(criteria, user);
        LoggerFactory.getLogger(this.getClass()).debug("get db by criteria '{}', result is '{}'.", criteria, (Object)result);
        Assertions.assertThat((Object)result).isNotNull();
    }

    @Test
    default public void testGetByCriteriaNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> {
            List result = this.getRepository().get((BaseCriteria)null, user);
            LoggerFactory.getLogger(this.getClass()).error("get by null criteria, expect exception but result is '{}'.", (Object)result);
        });
    }

    @Test
    default public void testGetByCriteriaNotIn() {
        Object user = this.getDataProvider().getUser();
        Object model = this.getDataProvider().getModel(user);
        List<Object> ids = Collections.singletonList(model.getId());
        Object criteria = this.getDataProvider().getEmptyCriteria();
        criteria.setIdFilter((IdFilter)new IdFilter().setNotIn(ids));
        criteria.getIdFilter().setEquals(model.getId());
        LoggerFactory.getLogger(this.getClass()).debug("get by criteria '{}'.", criteria);
        List foundEntities = this.getRepository().get(criteria, user);
        LoggerFactory.getLogger(this.getClass()).debug("get by criteria '{}', result is '{}'.", criteria, (Object)foundEntities);
        Assertions.assertThat((List)foundEntities).map(BaseModel::getId).doesNotContainAnyElementsOf(ids);
    }

    @Test
    default public void testGetOneNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getRepository().getOne(null, user));
    }

    @Test
    default public void testDeleteByCriteriaNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getRepository().delete((BaseCriteria)null, user));
    }

    @Test
    default public void testSave() {
        Object user = this.getDataProvider().getUser();
        Object model = this.getDataProvider().getUnsavedModel();
        LoggerFactory.getLogger(this.getClass()).debug("saving '{}'", model);
        BaseModel result = this.getRepository().save(model, user);
        LoggerFactory.getLogger(this.getClass()).debug("save '{}', result is '{}'.", model, (Object)result);
        this.getDataProvider().assertEqualSave(model, (BaseModel)result);
    }

    @Test
    default public void testSaveInvalid() {
        Object user = this.getDataProvider().getUser();
        Object model = this.getDataProvider().getUnsavedInvalidModel();
        LoggerFactory.getLogger(this.getClass()).debug("saving '{}'", model);
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> {
            BaseModel result = this.getRepository().save(model, user);
            LoggerFactory.getLogger(this.getClass()).debug("save invalid model '{}', expect exception but result is '{}'.", model, (Object)result);
        });
    }

    @Test
    default public void testSaveNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> {
            BaseModel result = this.getRepository().save((BaseModel)null, user);
            LoggerFactory.getLogger(this.getClass()).debug("save null model, expect exception but result is '{}'.", (Object)result);
        });
    }

    @Test
    default public void testSaveCollection() {
        Object user = this.getDataProvider().getUser();
        List list = this.getDataProvider().getUnsavedModels(RandomUtils.nextInt((int)1, (int)10), user);
        List result = this.getRepository().save(list, user);
        Assertions.assertThat((Collection)result).hasSameSizeAs(list);
        for (BaseModel savedEntity : result) {
            BaseModel entity = (BaseModel)list.get(list.indexOf(savedEntity));
            this.getDataProvider().assertEqualSave((BaseModel)entity, (BaseModel)savedEntity);
        }
    }

    @Test
    default public void testSaveCollectionEmpty() {
        Object user = this.getDataProvider().getUser();
        ArrayList list = new ArrayList();
        List saved = this.getRepository().save(list, user);
        Assertions.assertThat((List)saved).isEmpty();
    }

    @Test
    default public void testSaveCollectionInvalidMember() {
        int i;
        Object user = this.getDataProvider().getUser();
        int count = RandomUtils.nextInt((int)1, (int)10);
        ArrayList list = new ArrayList();
        for (i = 0; i < count; ++i) {
            list.add(this.getDataProvider().getUnsavedModel());
        }
        for (i = 0; i < RandomUtils.nextInt((int)1, (int)3); ++i) {
            list.add(RandomUtils.nextInt((int)0, (int)(list.size() - 1)), this.getDataProvider().getUnsavedInvalidModel());
        }
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getRepository().save((Collection)list, user));
    }

    @Test
    default public void testSaveCollectionNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getRepository().save((Collection)null, user));
    }

    @Test
    default public void testUpdate() {
        Object user = this.getDataProvider().getUser();
        Object sourceModel = this.getDataProvider().getModel(user);
        BaseModel updatedModel = this.getRepository().update(sourceModel, user);
        this.getDataProvider().assertEqualUpdate(sourceModel, (BaseModel)updatedModel);
    }

    @Test
    default public void testUpdateInvalidModel() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getRepository().update(this.getDataProvider().getInvalidModel(user), user));
    }

    @Test
    default public void testUpdateNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getRepository().update((BaseModel)null, user));
    }

    @Test
    default public void testUpdateUnsavedModel() {
        Object user = this.getDataProvider().getUser();
        Object model = this.getDataProvider().getModel(user);
        model.setId(this.getDataProvider().getInvalidId());
        this.getRepository().update(model, user);
        Assertions.assertThat((Object)this.getRepository().get(model.getId(), user)).isNull();
    }

    @Test
    default public void testFilter() {
        Object user = this.getDataProvider().getUser();
        int dataCount = RandomUtils.nextInt((int)1, (int)3);
        this.getDataProvider().getModels(dataCount, user, (Object[])new Object[0]);
        Object validFilter = this.getDataProvider().getEmptyCriteria();
        PagedData pagedData = this.getRepository().get(validFilter, (Pageable)PageRequest.of((int)1, (int)dataCount), user);
        Assertions.assertThat((long)pagedData.getTotal()).isGreaterThanOrEqualTo((long)dataCount);
        Assertions.assertThat((List)pagedData.getData()).isNotEmpty();
    }

    @Test
    default public void testFilterNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.getRepository().get(null, (Pageable)PageRequest.of((int)1, (int)Integer.MAX_VALUE), user));
    }

    @Test
    default public void testFilterIds() {
        Object user = this.getDataProvider().getUser();
        Object model = this.getDataProvider().getModel(user);
        Object criteria = this.getDataProvider().getEmptyCriteria();
        criteria.setIdFilter((IdFilter)new IdFilter().setEquals(model.getId()));
        Assertions.assertThat((List)this.getRepository().getIds(criteria, user)).size().isPositive();
    }

    @Test
    default public void testFilterIdsNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getRepository().getIds(null, user));
    }

    @Test
    default public void testFilterIdsNotIn() {
        Object user = this.getDataProvider().getUser();
        Object model = this.getDataProvider().getModel(user);
        List<Object> ids = Collections.singletonList(model.getId());
        Object criteria = this.getDataProvider().getEmptyCriteria();
        criteria.setIdFilter((IdFilter)new IdFilter().setNotIn(ids));
        criteria.getIdFilter().setEquals(model.getId());
        List list = this.getRepository().getIds(criteria, user);
        ((ListAssert)Assertions.assertThat((List)list).doesNotContain(new Object[]{model.getId()})).isEmpty();
    }

    @Test
    default public void testFilterCount() {
        Object user = this.getDataProvider().getUser();
        this.getDataProvider().getModel(user);
        Assertions.assertThat((long)this.getRepository().getCount(this.getDataProvider().getEmptyCriteria(), user)).isPositive();
    }

    @Test
    default public void testFilterCountNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getRepository().getCount(null, user));
    }

    @Test
    default public void testIsExist() {
        Object user = this.getDataProvider().getUser();
        this.getDataProvider().getModel(user);
        boolean result = this.getRepository().isExist(this.getDataProvider().getEmptyCriteria(), user);
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    default public void testIsExistNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getRepository().isExist(null, user));
    }
}

