/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.api.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.bardframework.crud.api.base.BaseCriteria;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.BaseService;
import org.bardframework.crud.api.base.PagedData;
import org.bardframework.crud.api.base.ServiceDataProvider;
import org.bardframework.form.model.filter.IdFilter;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public interface BaseServiceTest<M extends BaseModel<I>, C extends BaseCriteria<I>, D, S extends BaseService<M, C, D, ?, I, U>, P extends ServiceDataProvider<M, C, D, S, ?, I, U>, I, U> {
    public S getService();

    public P getDataProvider();

    default public M getListElement(List<M> list, I id) {
        return (M)((BaseModel)list.stream().filter(e -> e.getId().equals(id)).findFirst().orElse(null));
    }

    @Test
    default public void testGetById() {
        Object user = this.getDataProvider().getUser();
        Object id = this.getDataProvider().getId(user);
        BaseModel foundModel = this.getService().get(id, user);
        Assertions.assertThat((Object)foundModel).isNotNull();
        Assertions.assertThat((Object)foundModel.getId()).isEqualTo(id);
    }

    @Test
    default public void testGetByIdNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getService().get(null, user));
    }

    @Test
    default public void testGetByIdInvalid() {
        Object user = this.getDataProvider().getUser();
        Object id = this.getDataProvider().getInvalidId();
        BaseModel model = this.getService().get(id, user);
        Assertions.assertThat((Object)model).isNull();
    }

    @Test
    default public void testGetByCriteria() {
        Object user = this.getDataProvider().getUser();
        List savedList = this.getDataProvider().getModels(RandomUtils.nextInt((int)1, (int)10), user, (Object[])new Object[0]);
        List models = this.getService().get(this.getDataProvider().getEmptyCriteria(), user);
        ((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)models).isNotNull()).isNotEmpty()).doesNotContainNull()).size().isGreaterThanOrEqualTo(savedList.size());
    }

    @Test
    default public void testGetByCriteriaNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getService().get((BaseCriteria)null, user));
    }

    @Test
    default public void testGetByCriteriaNotIn() {
        Object user = this.getDataProvider().getUser();
        Object model = this.getDataProvider().getModel(user);
        Object criteria = this.getDataProvider().getEmptyCriteria();
        criteria.setIdFilter((IdFilter)new IdFilter().setNotEquals(model.getId()));
        List list = this.getService().get(criteria, user);
        Assertions.assertThat(list.stream().map(BaseModel::getId)).doesNotContain(new Object[]{model.getId()});
    }

    @Test
    default public void testDeleteById() {
        Object user = this.getDataProvider().getUser();
        BaseModel savedModel = (BaseModel)this.getDataProvider().saveNew(1L, user).get(0);
        long count = this.getService().delete(savedModel.getId(), user);
        Assertions.assertThat((long)count).isEqualByComparingTo((Comparable)Long.valueOf(1L));
        BaseModel foundModel = this.getService().get(savedModel.getId(), user);
        Assertions.assertThat((Object)foundModel).isNull();
    }

    @Test
    default public void testDeleteByIds() {
        Object user = this.getDataProvider().getUser();
        int count = RandomUtils.nextInt((int)3, (int)10);
        List saved = this.getDataProvider().saveNew(count, user);
        Collection ids = saved.stream().map(BaseModel::getId).collect(Collectors.toList());
        long size = this.getService().delete(ids, user);
        Assertions.assertThat((long)size).isEqualByComparingTo((Comparable)Long.valueOf(saved.size()));
        Assertions.assertThat((List)this.getService().get(ids, user)).isEmpty();
    }

    @Test
    default public void testDeleteByIdsDuplicate() {
        Object user = this.getDataProvider().getUser();
        int count = RandomUtils.nextInt((int)5, (int)20);
        List saved = this.getDataProvider().saveNew(count, user);
        ArrayList<Object> ids = new ArrayList<Object>();
        for (BaseModel m : saved) {
            ids.add(m.getId());
            ids.add(m.getId());
            ids.add(m.getId());
        }
        long size = this.getService().delete(ids, user);
        Assertions.assertThat((long)size).isEqualByComparingTo((Comparable)Long.valueOf(saved.size()));
        Assertions.assertThat((List)this.getService().get(ids, user)).isEmpty();
    }

    @Test
    default public void testDeleteByIdInvalid() {
        Object user = this.getDataProvider().getUser();
        Object invalidId = this.getDataProvider().getInvalidId();
        long count = this.getService().delete(invalidId, user);
        Assertions.assertThat((long)count).isEqualByComparingTo((Comparable)Long.valueOf(0L));
    }

    @Test
    default public void testSave() {
        Object user = this.getDataProvider().getUser();
        Object dto = this.getDataProvider().getDto();
        LoggerFactory.getLogger(this.getClass()).debug("saving '{}'", dto);
        BaseModel result = this.getService().save(dto, user);
        LoggerFactory.getLogger(this.getClass()).debug("save '{}', result is '{}'.", dto, (Object)result);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((Object)result.getId()).isNotNull();
        BaseModel model = this.getService().get(result.getId(), user);
        Assertions.assertThat((Object)model).isNotNull();
        this.getDataProvider().assertEqualSave((BaseModel)result, (BaseModel)model);
    }

    @Test
    default public void testSaveInvalid() {
        Object user = this.getDataProvider().getUser();
        Object invalidDto = this.getDataProvider().getInvalidDto();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getService().save(invalidDto, user));
    }

    @Test
    default public void testSaveNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getService().save(null, user));
    }

    @Test
    default public void testUpdate() {
        Object user = this.getDataProvider().getUser();
        Object id = this.getDataProvider().getId(user);
        Object dto = this.getDataProvider().getDto();
        LoggerFactory.getLogger(this.getClass()).debug("updating '{}'", dto);
        BaseModel result = this.getService().update(id, dto, user);
        LoggerFactory.getLogger(this.getClass()).debug("update '{}', result is '{}'.", dto, (Object)result);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat(id).isEqualTo(result.getId());
        BaseModel model = this.getService().get(id, user);
        Assertions.assertThat((Object)model).isNotNull();
        this.getDataProvider().assertEqualUpdate((BaseModel)model, dto);
    }

    @Test
    default public void testUpdateInvalid() {
        Object user = this.getDataProvider().getUser();
        Object id = this.getDataProvider().getId(user);
        Object invalidDto = this.getDataProvider().getInvalidDto();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getService().update(id, invalidDto, user));
    }

    @Test
    default public void testUpdateNull() {
        Object user = this.getDataProvider().getUser();
        Object id = this.getDataProvider().getId(user);
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getService().update(id, null, user));
    }

    @Test
    default public void testFilterCount() {
        Object user = this.getDataProvider().getUser();
        List savedList = this.getDataProvider().getModels(RandomUtils.nextInt((int)1, (int)10), user, (Object[])new Object[0]);
        long count = this.getService().getCount(this.getDataProvider().getEmptyCriteria(), user);
        Assertions.assertThat((long)count).isGreaterThanOrEqualTo((long)savedList.size());
    }

    @Test
    default public void testFilterCountNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getService().getCount(null, user));
    }

    @Test
    default public void testFilterIds() {
        Object user = this.getDataProvider().getUser();
        List savedList = this.getDataProvider().getModels(RandomUtils.nextInt((int)1, (int)5), user, (Object[])new Object[0]);
        List savedIds = savedList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List ids = this.getService().getIds(this.getDataProvider().getEmptyCriteria(), user);
        ((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)ids).isNotNull()).isNotEmpty()).doesNotContainNull()).containsAll(savedIds);
    }

    @Test
    default public void testFilterIdsNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getService().getIds(null, user));
    }

    @Test
    default public void testFilterIdsNotIn() {
        Object user = this.getDataProvider().getUser();
        Object model = this.getDataProvider().getModel(user);
        Object criteria = this.getDataProvider().getEmptyCriteria();
        criteria.setIdFilter((IdFilter)new IdFilter().setNotEquals(model.getId()));
        List list = this.getService().getIds(criteria, user);
        Assertions.assertThat((List)list).doesNotContain(new Object[]{model.getId()});
    }

    @Test
    default public void testFilter() {
        Object user = this.getDataProvider().getUser();
        List savedList = this.getDataProvider().getModels(RandomUtils.nextInt((int)1, (int)10), user, (Object[])new Object[0]);
        Object criteria = this.getDataProvider().getFilterCriteria(savedList);
        long count = this.getService().getCount(criteria, user);
        PagedData pagedData = this.getService().get(criteria, (Pageable)PageRequest.of((int)1, (int)((int)count)), user);
        Assertions.assertThat((Object)pagedData).isNotNull();
        Assertions.assertThat((long)pagedData.getTotal()).isGreaterThanOrEqualTo((long)savedList.size());
        ((ListAssert)((ListAssert)Assertions.assertThat((List)pagedData.getData()).isNotNull()).isNotEmpty()).doesNotContainNull();
        List savedIds = savedList.stream().map(BaseModel::getId).collect(Collectors.toList());
        Assertions.assertThat((List)pagedData.getData()).map(BaseModel::getId).containsAll(savedIds);
    }

    @Test
    default public void testFilterNull() {
        Object user = this.getDataProvider().getUser();
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.getService().get(null, (Pageable)PageRequest.of((int)1, (int)Integer.MAX_VALUE), user));
    }
}

