/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import com.fasterxml.jackson.databind.type.SimpleType;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.JsonViewRequestBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;

public class GenericRequestBodyResolverConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GenericRequestBodyResolverConfiguration.class);
    private final RequestMappingHandlerAdapter mappingHandler;

    public GenericRequestBodyResolverConfiguration(RequestMappingHandlerAdapter mappingHandler) {
        this.mappingHandler = mappingHandler;
    }

    @PostConstruct
    public void addCustomResolver() {
        List argumentResolvers = this.mappingHandler.getArgumentResolvers();
        if (CollectionUtils.isEmpty((Collection)argumentResolvers)) {
            log.warn("Argument handlers in [{}] is empty, can't add [{}].", (Object)this.mappingHandler.getClass().getSimpleName(), (Object)GenericRequestBodyMethodProcessor.class.getSimpleName());
            return;
        }
        Integer index = null;
        RequestResponseBodyMethodProcessor processor = null;
        for (int i = 0; i < argumentResolvers.size(); ++i) {
            HandlerMethodArgumentResolver argumentResolver = (HandlerMethodArgumentResolver)argumentResolvers.get(i);
            if (!(argumentResolver instanceof RequestResponseBodyMethodProcessor)) continue;
            index = i;
            processor = (RequestResponseBodyMethodProcessor)argumentResolver;
            break;
        }
        if (null == index) {
            log.warn("[{}] not exist in [{}] argument handlers, can't add [{}].", new Object[]{RequestResponseBodyMethodProcessor.class.getSimpleName(), this.mappingHandler.getClass().getSimpleName(), GenericRequestBodyMethodProcessor.class.getSimpleName()});
            return;
        }
        ArrayList<GenericRequestBodyMethodProcessor> newResolvers = new ArrayList<GenericRequestBodyMethodProcessor>(argumentResolvers);
        newResolvers.set(index, new GenericRequestBodyMethodProcessor(processor));
        this.mappingHandler.setArgumentResolvers(newResolvers);
    }

    private static class GenericRequestBodyMethodProcessor
    extends RequestResponseBodyMethodProcessor {
        public GenericRequestBodyMethodProcessor(RequestResponseBodyMethodProcessor processor) {
            super(processor.messageConverters, List.of(new JsonViewRequestBodyAdvice()));
        }

        protected Object readWithMessageConverters(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType) throws IOException, HttpMediaTypeNotSupportedException, HttpMessageNotReadableException {
            HttpInputMessageReadable httpInputMessage = new HttpInputMessageReadable(inputMessage);
            try {
                return super.readWithMessageConverters((HttpInputMessage)httpInputMessage, parameter, targetType);
            }
            catch (HttpMessageConversionException e) {
                return super.readWithMessageConverters((HttpInputMessage)httpInputMessage, parameter, (Type)SimpleType.constructUnsafe((Class)parameter.getParameterType()));
            }
        }
    }

    private static class HttpInputMessageReadable
    implements HttpInputMessage {
        private final byte[] bytes;
        private final HttpHeaders httpHeaders;

        private HttpInputMessageReadable(HttpInputMessage inputMessage) throws IOException {
            try (InputStream inputStream = inputMessage.getBody();){
                this.bytes = IOUtils.toByteArray((InputStream)inputStream);
            }
            this.httpHeaders = inputMessage.getHeaders();
        }

        public InputStream getBody() {
            return new ByteArrayInputStream(this.bytes);
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }
    }
}

