/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.api.base;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.bardframework.commons.utils.AssertionUtils;
import org.bardframework.commons.utils.ReflectionUtils;
import org.bardframework.crud.api.base.BaseCriteria;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.PagedData;
import org.bardframework.crud.api.base.ReadRepository;
import org.bardframework.form.model.filter.IdFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;

public abstract class ReadService<M extends BaseModel<I>, C extends BaseCriteria<I>, R extends ReadRepository<M, C, I, U>, I extends Serializable, U> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Class<M> modelClazz;
    protected final Class<C> criteriaClazz;
    protected final R repository;

    public ReadService(R repository) {
        this.repository = repository;
        this.modelClazz = ReflectionUtils.getGenericArgType(this.getClass(), (int)0);
        this.criteriaClazz = ReflectionUtils.getGenericArgType(this.getClass(), (int)1);
    }

    public C getEmptyCriteria() {
        return (C)((BaseCriteria)ReflectionUtils.newInstance(this.criteriaClazz));
    }

    public List<M> get(Collection<I> ids, U user) {
        AssertionUtils.notEmpty(ids, (String)"Given ids cannot be empty.");
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        C criteria = this.getEmptyCriteria();
        criteria.setIdFilter((IdFilter)new IdFilter().setIn(ids));
        return this.get(criteria, user);
    }

    public M get(I id, U user) {
        AssertionUtils.notNull(id, (String)"Given id cannot be null.");
        C criteria = this.getEmptyCriteria();
        criteria.setIdFilter((IdFilter)new IdFilter().setEquals(id));
        List<M> models = this.get(criteria, user);
        if (CollectionUtils.isEmpty(models)) {
            return null;
        }
        return (M)((BaseModel)models.get(0));
    }

    public List<M> get(U user) {
        return this.get(this.getEmptyCriteria(), user);
    }

    public List<M> get(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        this.preFetch(criteria, user);
        List list = this.getRepository().get(criteria, user);
        this.postFetch(criteria, list, user);
        return list;
    }

    public M getOne(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        this.preFetch(criteria, user);
        Object model = this.getRepository().getOne(criteria, user);
        this.postFetch(criteria, Collections.singletonList(model), user);
        return model;
    }

    public PagedData<M> get(C criteria, Pageable pageable, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        AssertionUtils.notNull((Object)pageable, (String)"Given pageable cannot be null.");
        this.preFetch(criteria, user);
        PagedData pagedData = this.getRepository().get(criteria, pageable, user);
        this.postFetch(criteria, pagedData.getData(), user);
        return pagedData;
    }

    protected void preFetch(C criteria, U user) {
    }

    protected void postFetch(C criteria, List<M> result, U user) {
        for (BaseModel model : result) {
            this.postFetch(model, user);
        }
    }

    protected void postFetch(M model, U user) {
    }

    public List<I> getIds(C criteria, U user) {
        return this.getRepository().getIds(criteria, user);
    }

    public long getCount(C criteria, U user) {
        return this.getRepository().getCount(criteria, user);
    }

    public boolean isExist(C criteria, U user) {
        return this.getRepository().isExist(criteria, user);
    }

    public boolean isNotExist(C criteria, U user) {
        return this.getRepository().isNotExist(criteria, user);
    }

    public R getRepository() {
        return this.repository;
    }
}

