/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.base.util;

import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;

public final class PageableExecutionUtils {
    private PageableExecutionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static <T> Page<T> getPage(List<T> content, Pageable pageable, long count) {
        Assert.notNull(content, (String)"Content must not be null!");
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        if (!pageable.isUnpaged() && pageable.getOffset() != 0L) {
            return content.size() != 0 && pageable.getPageSize() > content.size() ? new PageImpl(content, pageable, pageable.getOffset() + (long)content.size()) : new PageImpl(content, pageable, count);
        }
        return !pageable.isUnpaged() && pageable.getPageSize() <= content.size() ? new PageImpl(content, pageable, count) : new PageImpl(content, pageable, (long)content.size());
    }
}

