/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.base.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bardframework.base.crud.BaseCriteria;
import org.bardframework.base.crud.BaseModelAbstract;
import org.bardframework.base.crud.BaseRepository;
import org.bardframework.base.tree.TreeEntityCriteria;
import org.bardframework.base.tree.TreeEntityModel;
import org.bardframework.base.tree.TreeEntityRepository;
import org.slf4j.Logger;

public interface TreeEntityService<M extends BaseModelAbstract<I>, C extends BaseCriteria<I> & TreeEntityCriteria<I>, R extends BaseRepository<M, C, I, U> & TreeEntityRepository<M, I, U>, I extends Comparable<? super I>, U> {
    public M getEmptyModel();

    public C getEmptyCriteria();

    public R getRepository();

    public Logger getLogger();

    default public M getTree(U user) {
        return this.toTree(this.getRepository().get(this.getEmptyCriteria(), user));
    }

    default public M getTree(I rootId, U user) {
        return this.toTree(((TreeEntityRepository)this.getRepository()).getWithChildren(rootId, user));
    }

    default public M toTree(List<M> list) {
        Map map = list.stream().collect(Collectors.toMap(BaseModelAbstract::getId, Function.identity()));
        ArrayList<BaseModelAbstract> roots = new ArrayList<BaseModelAbstract>();
        for (BaseModelAbstract child : list) {
            if (((TreeEntityModel)((Object)child)).getParent() != null) {
                BaseModelAbstract parent = (BaseModelAbstract)map.get(((BaseModelAbstract)((TreeEntityModel)((Object)child)).getParent()).getId());
                if (null == parent) {
                    this.getLogger().warn("can't find parent {}", ((TreeEntityModel)((Object)child)).getParent());
                } else {
                    ((TreeEntityModel)((Object)parent)).addChild(child);
                }
                ((TreeEntityModel)((Object)child)).setParent(null);
                continue;
            }
            roots.add(child);
        }
        if (roots.size() == 1) {
            return (M)((BaseModelAbstract)roots.get(0));
        }
        M root = this.getEmptyModel();
        ((TreeEntityModel)root).setChildren(roots);
        return root;
    }
}

