/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.base.datatable;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.bardframework.base.datatable.DataTableStructure;
import org.bardframework.base.datatable.HeaderAbstract;
import org.bardframework.commons.reflection.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DataTableUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTableUtils.class);
    private final Map<Class<?>, DataTableStructure> structureMap = new ConcurrentHashMap();
    @Autowired
    private List<DataTableStructure> structures;

    @PostConstruct
    private void init() throws NoSuchFieldException, IllegalAccessException {
        this.initTableMap();
        for (DataTableStructure structure : this.structures) {
            this.structureMap.put(structure.getClazz(), structure);
            for (HeaderAbstract header : structure.getHeaders()) {
                Object columnName = null;
                try {
                    Class containerClazz = ReflectionUtils.getContainerClassByGetter(structure.getClazz(), (String)header.getPath());
                }
                catch (NoSuchMethodException e) {
                    LOGGER.error("error fetching getters {} from {}.", new Object[]{header.getPath(), structure.getClazz(), e});
                    throw new IllegalArgumentException("can't find field in path " + header.getPath() + " from class " + structure.getClazz().getSimpleName());
                }
                Field field = ReflectionUtils.getField(structure.getClazz(), (String)header.getPath());
                if (null == field) {
                    Method method;
                    try {
                        method = ReflectionUtils.getGetterMethod(structure.getClazz(), (String)header.getPath());
                    }
                    catch (NoSuchMethodException e) {
                        LOGGER.error("error fetching getters {} from {}.", new Object[]{header.getPath(), structure.getClazz(), e});
                        throw new IllegalArgumentException("can't find field in path " + header.getPath() + " from class " + structure.getClazz().getSimpleName());
                    }
                    String fieldName = ReflectionUtils.methodToFieldName((Method)method);
                    continue;
                }
                if (null == columnName) continue;
            }
        }
    }

    private void initTableMap() throws NoSuchFieldException, IllegalAccessException {
    }

    public List<HeaderAbstract> getHeaders(Class<?> clazz) {
        if (!this.structureMap.containsKey(clazz)) {
            LOGGER.error("no '{}' found with key '{}'.", (Object)DataTableStructure.class.getSimpleName(), (Object)clazz.getSimpleName());
            throw new IllegalArgumentException("no structure found with key: " + clazz.getSimpleName());
        }
        return this.structureMap.get(clazz).getHeaders();
    }
}

