/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.base.crud;

import java.net.URI;
import java.net.URISyntaxException;
import org.bardframework.base.crud.BaseModelAbstract;
import org.bardframework.base.crud.BaseService;
import org.bardframework.base.crud.ValidationGroups;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public interface WriteRestController<M extends BaseModelAbstract<I>, D, S extends BaseService<M, ?, D, I, U>, I extends Comparable<? super I>, U> {
    public static final String SAVE_URL = "";
    public static final String UPDATE_URL = "{id}";
    public static final String DELETE_URL = "{id}";

    @PostMapping(value={""}, consumes={"application/json"})
    default public ResponseEntity<M> SAVE(@RequestBody @Validated(value={ValidationGroups.Save.class}) D dto) throws URISyntaxException {
        Object result = this.getService().save(dto, this.getUser());
        return ResponseEntity.created((URI)new URI(SAVE_URL + ((BaseModelAbstract)result).getId())).body(result);
    }

    @PutMapping(value={"{id}"}, consumes={"application/json"})
    default public ResponseEntity<M> UPDATE(@PathVariable I id, @RequestBody @Validated(value={ValidationGroups.Update.class}) D dto) {
        Object result = this.getService().update(id, dto, this.getUser());
        return ResponseEntity.ok().body(result);
    }

    @DeleteMapping(value={"{id}"})
    default public ResponseEntity<Void> DELETE(@PathVariable I id) {
        long result = this.getService().delete(id, this.getUser());
        return result == 0L ? ResponseEntity.noContent().build() : ResponseEntity.ok().build();
    }

    public S getService();

    public U getUser();
}

