/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.base.crud;

import java.util.Optional;
import org.bardframework.base.crud.BaseCriteriaAbstract;
import org.bardframework.base.crud.BaseModelAbstract;
import org.bardframework.base.crud.BaseService;
import org.bardframework.base.util.ResponseUtil;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public interface ReadRestController<M extends BaseModelAbstract<I>, C extends BaseCriteriaAbstract<I>, S extends BaseService<M, C, ?, I, U>, I extends Comparable<? super I>, U> {
    public static final String GET_LIST_URL = "";
    public static final String GET_URL = "{id}";
    public static final String FILTER_URL = "filter";

    @GetMapping(value={"{id}"})
    default public ResponseEntity<M> GET(@PathVariable I id) {
        Optional result = Optional.ofNullable(this.getService().get(id, this.getUser()));
        return ResponseUtil.wrapOrNotFound(result);
    }

    @PostMapping(value={"filter"}, consumes={"application/json"})
    default public ResponseEntity<Page<M>> FILTER(@RequestBody @Validated C criteria, Pageable page) {
        Page result = this.getService().get(criteria, page, this.getUser());
        return ResponseEntity.ok().body(result);
    }

    @GetMapping(value={""})
    default public ResponseEntity<Page<M>> GET(@Validated C criteria, Pageable page) {
        Page result = this.getService().get(criteria, page, this.getUser());
        return ResponseEntity.ok().body(result);
    }

    public S getService();

    public U getUser();
}

