/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.web.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.utils.StringTemplateUtils;
import org.bardframework.commons.utils.UrlUtils;
import org.bardframework.commons.web.http.HttpCallResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpCallResult httpCall(String httpMethod, String urlTemplate, String bodyTemplate, int connectTimeoutSeconds, int readTimeoutSeconds, Map<String, String> headers, Map<String, String> args) throws IOException {
        if (StringUtils.isBlank((CharSequence)httpMethod)) {
            throw new IllegalStateException("empty http method not acceptable");
        }
        if (StringUtils.isBlank((CharSequence)urlTemplate)) {
            throw new IllegalStateException("empty url not acceptable");
        }
        HttpURLConnection connection = null;
        try {
            urlTemplate = UrlUtils.fillUrlTemplate((String)urlTemplate, args);
            connection = (HttpURLConnection)new URL(urlTemplate).openConnection();
            connection.setRequestMethod(httpMethod);
            connection.setConnectTimeout(connectTimeoutSeconds * 1000);
            connection.setReadTimeout(readTimeoutSeconds * 1000);
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    if (null == entry.getValue()) {
                        log.debug("value of header [{}] is null, ignoring it", (Object)entry.getKey());
                        continue;
                    }
                    String headerValue = StringTemplateUtils.fillTemplate((String)entry.getValue(), args);
                    connection.setRequestProperty(entry.getKey(), headerValue);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)bodyTemplate)) {
                log.debug("setting request body, http method [{}] ", (Object)httpMethod);
                connection.setDoOutput(true);
                String body = StringTemplateUtils.fillTemplate((String)bodyTemplate, args);
                try (OutputStream outputStream = connection.getOutputStream();){
                    outputStream.write(body.getBytes(StandardCharsets.UTF_8));
                }
            }
            int responseCode = connection.getResponseCode();
            InputStream stream = connection.getErrorStream();
            if (null == stream) {
                try {
                    stream = connection.getInputStream();
                }
                catch (Exception e) {
                    log.trace("error reading input stream of http call response when error stream is null", (Throwable)e);
                }
            }
            byte[] response = null == stream ? null : IOUtils.toByteArray((InputStream)stream);
            String responseString = null == response ? null : IOUtils.toString((byte[])response, (String)StandardCharsets.UTF_8.displayName());
            log.debug("http call[{}] response, code: [{}], details: [{}]", new Object[]{urlTemplate, responseCode, responseString});
            HttpCallResult httpCallResult = new HttpCallResult(responseCode, response, null != connection.getErrorStream());
            return httpCallResult;
        }
        finally {
            if (null != connection) {
                connection.disconnect();
            }
        }
    }

    private HttpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

