/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.web.utils;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.util.FileCopyUtils;

public final class WebUtils {
    private static final char RLO = '\u202e';
    private static final char EMPTY = '\u0000';
    private static final char UNDERLINE = '_';
    private static final char SPACE = ' ';

    private WebUtils() {
    }

    public static void fillResponse(HttpServletResponse response, byte[] data, String contentType, String name) throws IOException {
        response.setContentType(contentType);
        response.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        String fileName = URLEncoder.encode(name, StandardCharsets.UTF_8).replace("+", "%20");
        response.setHeader("Content-Disposition", String.format("attachment; filename*=UTF-8''%s", fileName));
        response.setContentLength(data.length);
        FileCopyUtils.copy((byte[])data, (OutputStream)response.getOutputStream());
    }

    public static String escapeString(String value) {
        if (null == value) {
            return null;
        }
        return StringEscapeUtils.escapeHtml4((String)value).replace('\u202e', '\u0000').replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').replace('\"', '_').replace('\'', '_').replace('<', '_').replace('>', '_');
    }
}

