/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.web.cors;

import java.util.List;
import javax.servlet.Filter;
import org.bardframework.commons.security.SecurityConfigurer;
import org.bardframework.commons.web.cors.CorsFilter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;

public class CorsSecurityConfigurer
implements SecurityConfigurer {
    private final List<String> corsMapping;
    private final List<String> corsAllowedOrigins;
    private final List<String> corsAllowedMethods;
    private final List<String> corsAllowedHeaders;
    private final List<String> corsExposedHeaders;
    private final boolean corsAllowCredentials;
    private final int corsMaxAge;

    public CorsSecurityConfigurer(List<String> corsMapping, List<String> corsAllowedOrigins, List<String> corsAllowedMethods, List<String> corsAllowedHeaders, List<String> corsExposedHeaders, boolean corsAllowCredentials, int corsMaxAge) {
        this.corsMapping = corsMapping;
        this.corsAllowedOrigins = corsAllowedOrigins;
        this.corsAllowedMethods = corsAllowedMethods;
        this.corsAllowedHeaders = corsAllowedHeaders;
        this.corsExposedHeaders = corsExposedHeaders;
        this.corsAllowCredentials = corsAllowCredentials;
        this.corsMaxAge = corsMaxAge;
    }

    public void configure(HttpSecurity httpSecurity) {
        httpSecurity.addFilterBefore((Filter)this.getCorsFilter(), ChannelProcessingFilter.class);
    }

    protected List<String> getCorsMapping() {
        return this.corsMapping;
    }

    protected List<String> getCorsAllowedOrigins() {
        return this.corsAllowedOrigins;
    }

    protected List<String> getCorsAllowedMethods() {
        return this.corsAllowedMethods;
    }

    protected List<String> getCorsAllowedHeaders() {
        return this.corsAllowedHeaders;
    }

    protected List<String> getCorsExposedHeaders() {
        return this.corsExposedHeaders;
    }

    protected boolean isCorsAllowCredentials() {
        return this.corsAllowCredentials;
    }

    protected int getCorsMaxAge() {
        return this.corsMaxAge;
    }

    protected CorsFilter getCorsFilter() {
        return new CorsFilter(this.getCorsMapping(), this.getCorsAllowedOrigins(), this.getCorsAllowedMethods(), this.getCorsAllowedHeaders(), this.getCorsExposedHeaders(), this.isCorsAllowCredentials(), this.getCorsMaxAge());
    }
}

