/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.web.cookie;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;
import org.springframework.web.util.CookieGenerator;
import org.springframework.web.util.WebUtils;

public class CookieHandler
extends CookieGenerator {
    @Nullable
    private String cookieSameSite;

    public Cookie get(HttpServletRequest request) {
        return WebUtils.getCookie((HttpServletRequest)request, (String)this.getCookieName());
    }

    public String getValue(HttpServletRequest request) {
        Cookie cookie = this.get(request);
        return null == cookie ? null : cookie.getValue();
    }

    protected Cookie createCookie(String cookieValue) {
        Cookie cookie = new Cookie(this.getCookieName(), cookieValue);
        if (StringUtils.isNotBlank((CharSequence)this.getCookieDomain())) {
            cookie.setDomain(this.getCookieDomain());
        }
        cookie.setPath(this.getCookiePath());
        return cookie;
    }

    public void addCookie(HttpServletResponse response, String cookieValue) {
        this.addCookie(response, cookieValue, this.getCookieMaxAge());
    }

    public void addCookie(HttpServletResponse response, String cookieValue, Integer maxAge) {
        StringBuilder setCookieHeader = new StringBuilder(String.format("%s=%s;", this.getCookieName(), cookieValue));
        if (null != maxAge) {
            setCookieHeader.append(String.format("Max-Age=%d;", maxAge));
        }
        if (this.isCookieSecure()) {
            setCookieHeader.append("Secure;");
        }
        if (this.isCookieHttpOnly()) {
            setCookieHeader.append("HttpOnly;");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getCookieDomain())) {
            setCookieHeader.append(String.format("Domain=%s;", this.getCookieDomain()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getCookiePath())) {
            setCookieHeader.append(String.format("Path=%s;", this.getCookiePath()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getCookieSameSite())) {
            setCookieHeader.append(String.format("SameSite=%s;", this.getCookieSameSite()));
        }
        response.addHeader("Set-Cookie", setCookieHeader.toString());
    }

    @Nullable
    public String getCookieSameSite() {
        return this.cookieSameSite;
    }

    public void setCookieSameSite(@Nullable String cookieSameSite) {
        this.cookieSameSite = cookieSameSite;
    }
}

