/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.waf;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bardframework.commons.waf.RequestCallCounter;
import org.bardframework.commons.waf.exception.CallLimitExceedException;
import org.bardframework.commons.waf.extractor.RequestKeyDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

public class RequestLimitChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestLimitChecker.class);
    private static final String PREFIX = "CALL_LIMITER_";
    private final AntPathRequestMatcher requestMatcher;
    private final RequestCallCounter requestCallCounter;
    private final RequestKeyDetector requestKeyDetector;
    private final HttpMethod httpMethod;
    private final int limit;
    private final int period;
    private final TimeUnit periodUnit;
    private Set<String> whiteList = new HashSet<String>();

    public RequestLimitChecker(String url, RequestCallCounter requestCallCounter, RequestKeyDetector requestKeyDetector, int limit, int period, TimeUnit periodUnit) {
        this.httpMethod = null;
        this.requestMatcher = new AntPathRequestMatcher(url);
        this.requestCallCounter = requestCallCounter;
        this.requestKeyDetector = requestKeyDetector;
        this.limit = limit;
        this.period = period;
        this.periodUnit = periodUnit;
    }

    public RequestLimitChecker(HttpMethod httpMethod, String url, RequestCallCounter requestCallCounter, RequestKeyDetector requestKeyDetector, int limit, int period, TimeUnit periodUnit) {
        this.httpMethod = httpMethod;
        this.requestMatcher = new AntPathRequestMatcher(url, httpMethod.name());
        this.requestCallCounter = requestCallCounter;
        this.requestKeyDetector = requestKeyDetector;
        this.limit = limit;
        this.period = period;
        this.periodUnit = periodUnit;
    }

    public void checkCallLimit(HttpServletRequest request, HttpServletResponse response) throws CallLimitExceedException {
        Object key = this.requestKeyDetector.getUniqueKey(request, response);
        if (null == key) {
            LOGGER.warn("can't detect unique key of request [{} {}] for checking call limit", (Object)request.getMethod(), (Object)request.getRequestURI());
            return;
        }
        if (this.whiteList.contains(key)) {
            LOGGER.debug("request [{} {}] with unique key[{}] not checked, unique key is in white list", new Object[]{request.getMethod(), request.getRequestURI(), key});
            return;
        }
        long count = this.requestCallCounter.increment((String)(key = PREFIX + (String)key + (String)(null == this.httpMethod ? "" : "@" + this.httpMethod) + "@" + this.requestMatcher.getPattern()));
        if (count > (long)this.limit) {
            throw new CallLimitExceedException((String)key);
        }
        if (count == 1L) {
            this.requestCallCounter.expire((String)key, this.period, this.periodUnit);
        }
    }

    public boolean match(HttpServletRequest request) {
        return this.requestMatcher.matches(request);
    }

    public void setWhiteList(String ... whiteList) {
        this.whiteList = new HashSet<String>(Arrays.asList(whiteList));
    }

    public int getLimit() {
        return this.limit;
    }

    public int getPeriod() {
        return this.period;
    }

    public TimeUnit getPeriodUnit() {
        return this.periodUnit;
    }
}

