/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.utils.StringTemplateUtils;
import org.bardframework.commons.utils.UrlUtils;
import org.bardframework.commons.utils.http.HttpCallRequest;
import org.bardframework.commons.utils.http.HttpCallResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static HttpCallResponse httpCall(String httpMethod, String urlTemplate, String bodyTemplate, int connectTimeoutSeconds, int readTimeoutSeconds, Map<String, String> headers, Map<String, String> args) throws IOException {
        HashedMap multiValueHeaders = new HashedMap();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            multiValueHeaders.put(entry.getKey(), List.of(entry.getValue()));
        }
        HttpCallRequest request = new HttpCallRequest().httpMethod(httpMethod).urlTemplate(urlTemplate).bodyTemplate(bodyTemplate).headers((Map<String, List<String>>)multiValueHeaders);
        return HttpUtils.httpCall(request, connectTimeoutSeconds, readTimeoutSeconds, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpCallResponse httpCall(HttpCallRequest request, int connectTimeoutSeconds, int readTimeoutSeconds, Map<String, String> args) throws IOException {
        if (StringUtils.isBlank((CharSequence)request.getHttpMethod())) {
            throw new IllegalStateException("empty http method not acceptable");
        }
        if (StringUtils.isBlank((CharSequence)request.getUrlTemplate())) {
            throw new IllegalStateException("empty url not acceptable");
        }
        HttpURLConnection connection = null;
        try {
            String url = UrlUtils.fillUrlTemplate(request.getUrlTemplate(), args);
            connection = (HttpURLConnection)URI.create(url).toURL().openConnection();
            connection.setRequestMethod(request.getHttpMethod());
            connection.setConnectTimeout(connectTimeoutSeconds * 1000);
            connection.setReadTimeout(readTimeoutSeconds * 1000);
            if (MapUtils.isNotEmpty(request.getHeaders())) {
                for (Map.Entry<String, List<String>> entry : request.getHeaders().entrySet()) {
                    for (String valueTemplate : entry.getValue()) {
                        if (null == valueTemplate) {
                            log.debug("value of header [{}] is null, ignoring it", (Object)entry.getKey());
                            continue;
                        }
                        String headerValue = StringTemplateUtils.fillTemplate(valueTemplate, args);
                        connection.setRequestProperty(entry.getKey(), headerValue);
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)request.getBodyTemplate())) {
                log.debug("setting request body, http method [{}] ", (Object)request.getHttpMethod());
                connection.setDoOutput(true);
                String body = StringTemplateUtils.fillTemplate(request.getBodyTemplate(), args);
                try (OutputStream outputStream = connection.getOutputStream();){
                    outputStream.write(body.getBytes(StandardCharsets.UTF_8));
                }
            }
            int responseCode = connection.getResponseCode();
            InputStream errorStream = connection.getErrorStream();
            InputStream responseStream = connection.getInputStream();
            byte[] response = null == responseStream ? new byte[]{} : IOUtils.toByteArray((InputStream)responseStream);
            byte[] error = null == errorStream ? new byte[]{} : IOUtils.toByteArray((InputStream)errorStream);
            log.trace("http call[{}] response, code: [{}], details: [{}]", new Object[]{url, responseCode, IOUtils.toString((byte[])response, (String)StandardCharsets.UTF_8.displayName())});
            HttpCallResponse httpCallResponse = new HttpCallResponse(responseCode, response, error, connection.getHeaderFields());
            return httpCallResponse;
        }
        finally {
            if (null != connection) {
                connection.disconnect();
            }
        }
    }

    private HttpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

