/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class AssertionUtils {
    public static void ge(long greater, long smaller, String message) {
        if (greater < smaller) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void ge(long greater, long smaller) {
        AssertionUtils.ge(greater, smaller, "[Assertion failed] - first argument '" + greater + "' must greater than or equal with second argument '" + smaller + "'");
    }

    public static void gt(long greater, long smaller, String message) {
        if (greater <= smaller) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void gt(long greater, long smaller) {
        AssertionUtils.gt(greater, smaller, "[Assertion failed] - first argument '" + greater + "' must greater than second argument '" + smaller + "'");
    }

    public static void assertEquals(byte[] file1, byte[] file2) {
        if (null == file1 ^ null == file2) {
            throw new IllegalArgumentException("files aren't match");
        }
    }

    public static void state(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void state(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalStateException(AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isTrue(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalArgumentException(AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    public static void isNull(Object object, String message) {
        if (object != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isNull(Object object, Supplier<String> messageSupplier) {
        if (object != null) {
            throw new IllegalArgumentException(AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object object, Supplier<String> messageSupplier) {
        if (object == null) {
            throw new IllegalArgumentException(AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    public static void isNotBlank(String text, String message) {
        if (!StringUtils.isNotBlank((CharSequence)text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isNotBlank(String text, Supplier<String> messageSupplier) {
        if (!StringUtils.isNotBlank((CharSequence)text)) {
            throw new IllegalArgumentException(AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    public static void hasText(String text, String message) {
        if (!StringUtils.isNotBlank((CharSequence)text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasText(String text, Supplier<String> messageSupplier) {
        if (!StringUtils.isNotBlank((CharSequence)text)) {
            throw new IllegalArgumentException(AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    public static void doesNotContain(String textToSearch, String substring, String message) {
        if (StringUtils.isNotBlank((CharSequence)textToSearch) && StringUtils.isNotBlank((CharSequence)substring) && textToSearch.contains(substring)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void doesNotContain(String textToSearch, String substring, Supplier<String> messageSupplier) {
        if (StringUtils.isNotBlank((CharSequence)textToSearch) && StringUtils.isNotBlank((CharSequence)substring) && textToSearch.contains(substring)) {
            throw new IllegalArgumentException(AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    public static void notEmpty(Object[] array, String message) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array, Supplier<String> messageSupplier) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            throw new IllegalArgumentException(AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    public static void noNullElements(Object[] array, String message) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static void noNullElements(Object[] array, Supplier<String> messageSupplier) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw new IllegalArgumentException(AssertionUtils.nullSafeGet(messageSupplier));
            }
        }
    }

    public static void notEmpty(Collection<?> collection, String message) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Collection<?> collection, Supplier<String> messageSupplier) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    public static void noNullElements(Collection<?> collection, String message) {
        if (collection != null) {
            for (Object element : collection) {
                if (element != null) continue;
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static void noNullElements(Collection<?> collection, Supplier<String> messageSupplier) {
        if (collection != null) {
            for (Object element : collection) {
                if (element != null) continue;
                throw new IllegalArgumentException(AssertionUtils.nullSafeGet(messageSupplier));
            }
        }
    }

    public static void notEmpty(Map<?, ?> map, String message) {
        if (MapUtils.isEmpty(map)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Map<?, ?> map, Supplier<String> messageSupplier) {
        if (MapUtils.isEmpty(map)) {
            throw new IllegalArgumentException(AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj, String message) {
        AssertionUtils.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            AssertionUtils.instanceCheckFailed(type, obj, message);
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj, Supplier<String> messageSupplier) {
        AssertionUtils.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            AssertionUtils.instanceCheckFailed(type, obj, AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj) {
        AssertionUtils.isInstanceOf(type, obj, "");
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, String message) {
        AssertionUtils.notNull(superType, "Super type to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            AssertionUtils.assignableCheckFailed(superType, subType, message);
        }
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, Supplier<String> messageSupplier) {
        AssertionUtils.notNull(superType, "Super type to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            AssertionUtils.assignableCheckFailed(superType, subType, AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) {
        AssertionUtils.isAssignable(superType, subType, "");
    }

    private static void instanceCheckFailed(Class<?> type, Object obj, String msg) {
        String className = obj != null ? obj.getClass().getName() : "null";
        Object result = "";
        boolean defaultMessage = true;
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            if (AssertionUtils.endsWithSeparator(msg)) {
                result = msg + " ";
            } else {
                result = AssertionUtils.messageWithTypeName(msg, className);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result = (String)result + "Object of class [" + className + "] must be an instance of " + String.valueOf(type);
        }
        throw new IllegalArgumentException((String)result);
    }

    private static void assignableCheckFailed(Class<?> superType, Class<?> subType, String msg) {
        Object result = "";
        boolean defaultMessage = true;
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            if (AssertionUtils.endsWithSeparator(msg)) {
                result = msg + " ";
            } else {
                result = AssertionUtils.messageWithTypeName(msg, subType);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result = (String)result + String.valueOf(subType) + " is not assignable to " + String.valueOf(superType);
        }
        throw new IllegalArgumentException((String)result);
    }

    private static boolean endsWithSeparator(String msg) {
        return msg.endsWith(":") || msg.endsWith(";") || msg.endsWith(",") || msg.endsWith(".");
    }

    private static String messageWithTypeName(String msg, Object typeName) {
        return msg + (msg.endsWith(" ") ? "" : ": ") + String.valueOf(typeName);
    }

    private static String nullSafeGet(Supplier<String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }

    private AssertionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

