/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils;

public final class IpUtils {
    private IpUtils() {
    }

    public static String formatIp(String ip) {
        StringBuilder builder = new StringBuilder();
        try {
            for (String num : ip.split("\\.")) {
                short part = Short.parseShort(num);
                if (part < 0) {
                    throw new IllegalArgumentException(ip);
                }
                builder.append(String.format("%03d", part));
                builder.append(".");
            }
            String finalIp = builder.substring(0, builder.length() - 1);
            if (finalIp.length() != 15) {
                throw new IllegalArgumentException(ip);
            }
            return finalIp;
        }
        catch (NullPointerException | NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("error validating ip %s", ip), ex);
        }
    }
}

