/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Formatter;
import java.util.stream.IntStream;

public final class EncodingUtils {
    private EncodingUtils() {
    }

    public static String hexEncode(byte[] data) {
        StringBuilder stringBuilder = new StringBuilder();
        try (Formatter formatter = new Formatter(stringBuilder);){
            IntStream.range(0, data.length).forEach(i -> formatter.format("%02x", data[i]));
            String string = stringBuilder.toString();
            return string;
        }
    }

    public static String encodeBase64(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public static byte[] decodeBase64(String data) {
        return Base64.getDecoder().decode(data);
    }

    public static byte[] decodeBase64(byte[] data) {
        return Base64.getDecoder().decode(data);
    }

    public static byte[] encodeBase64ToByteArray(byte[] data) {
        return Base64.getEncoder().encode(data);
    }

    public static String urlEncode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }
}

