/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class NumberUtils {
    private NumberUtils() {
    }

    public static Long getLastDigit(long number, int countOfLastDigit) {
        int length = String.valueOf(number).length();
        if (length <= countOfLastDigit) {
            return number;
        }
        return Long.valueOf(String.valueOf(number).substring(length - countOfLastDigit, length));
    }

    public static Long getNumeric(String num) {
        try {
            num = num.trim();
            boolean minus = num.charAt(0) == '-';
            for (char c : num.toCharArray()) {
                if (Character.isDigit(c)) continue;
                num = num.replace(String.valueOf(c), "");
            }
            return Long.valueOf((minus ? "-" : "") + num);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException | NumberFormatException | StringIndexOutOfBoundsException ex) {
            return 0L;
        }
    }

    public static Long getNumeric(Object num) {
        if (num != null) {
            return NumberUtils.getNumeric(num.toString());
        }
        return 0L;
    }

    public static Set<Long> getNumeric(Collection<String> collection) {
        HashSet<Long> temp = new HashSet<Long>();
        if (collection != null) {
            for (String num : collection) {
                temp.add(NumberUtils.getNumeric(num));
            }
        }
        return temp;
    }

    public static double getDouble(Object object) {
        if (object == null) {
            return 0.0;
        }
        String num = object.toString();
        for (char c : num.toCharArray()) {
            if (Character.isDigit(c)) continue;
            num = num.replace(String.valueOf(c), "");
        }
        if (!num.isEmpty()) {
            try {
                return Double.parseDouble(num);
            }
            catch (NumberFormatException ex) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public static Set<Long> getNumbers(String string) {
        HashSet<Long> numbers = new HashSet<Long>();
        if (string != null && !string.isEmpty()) {
            int i = 0;
            while (i < string.length()) {
                StringBuilder number = new StringBuilder();
                while (i < string.length() && Character.isDigit(string.charAt(i++))) {
                    number.append(string.charAt(i - 1));
                }
                if (number.length() <= 0) continue;
                numbers.add((long)(string.charAt(i - number.length() - 2) == '-' ? -1 : 1) * Long.parseLong(number.toString()));
            }
        }
        return numbers;
    }

    public static long toLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }
}

