/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils;

import java.util.HashMap;
import java.util.Map;

public abstract class HtmlUtils {
    private static final HtmlCharacterEntityReferences characterEntityReferences = new HtmlCharacterEntityReferences();

    private HtmlUtils() {
    }

    public static String htmlEscape(String input, String encoding) {
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            String reference = characterEntityReferences.convertToReference(character, encoding);
            if (reference != null) {
                escaped.append(reference);
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlUnescape(String input) {
        return new HtmlCharacterEntityDecoder(characterEntityReferences, input).decode();
    }

    private static class HtmlCharacterEntityReferences {
        static final char CHAR_NULL = '\uffff';
        private static final char REFERENCE_START = '&';
        private static final char REFERENCE_END = ';';
        private final String[] characterToEntityReferenceMap = new String[3000];
        private final Map<String, Character> entityReferenceToCharacterMap = new HashMap<String, Character>(512);

        HtmlCharacterEntityReferences() {
            String[] keys;
            String chars = "160=nbsp\n161=iexcl\n162=cent\n163=pound\n164=curren\n165=yen\n166=brvbar\n167=sect\n168=uml\n169=copy\n170=ordf\n171=laquo\n172=not\n173=shy\n174=reg\n175=macr\n176=deg\n177=plusmn\n178=sup2\n179=sup3\n180=acute\n181=micro\n182=para\n183=middot\n184=cedil\n185=sup1\n186=ordm\n187=raquo\n188=frac14\n189=frac12\n190=frac34\n191=iquest\n192=Agrave\n193=Aacute\n194=Acirc\n195=Atilde\n196=Auml\n197=Aring\n198=AElig\n199=Ccedil\n200=Egrave\n201=Eacute\n202=Ecirc\n203=Euml\n204=Igrave\n205=Iacute\n206=Icirc\n207=Iuml\n208=ETH\n209=Ntilde\n210=Ograve\n211=Oacute\n212=Ocirc\n213=Otilde\n214=Ouml\n215=times\n216=Oslash\n217=Ugrave\n218=Uacute\n219=Ucirc\n220=Uuml\n221=Yacute\n222=THORN\n223=szlig\n224=agrave\n225=aacute\n226=acirc\n227=atilde\n228=auml\n229=aring\n230=aelig\n231=ccedil\n232=egrave\n233=eacute\n234=ecirc\n235=euml\n236=igrave\n237=iacute\n238=icirc\n239=iuml\n240=eth\n241=ntilde\n242=ograve\n243=oacute\n244=ocirc\n245=otilde\n246=ouml\n247=divide\n248=oslash\n249=ugrave\n250=uacute\n251=ucirc\n252=uuml\n253=yacute\n254=thorn\n255=yuml\n\n402=fnof\n913=Alpha\n914=Beta\n915=Gamma\n916=Delta\n917=Epsilon\n918=Zeta\n919=Eta\n920=Theta\n921=Iota\n922=Kappa\n923=Lambda\n924=Mu\n925=Nu\n926=Xi\n927=Omicron\n928=Pi\n929=Rho\n931=Sigma\n932=Tau\n933=Upsilon\n934=Phi\n935=Chi\n936=Psi\n937=Omega\n945=alpha\n946=beta\n947=gamma\n948=delta\n949=epsilon\n950=zeta\n951=eta\n952=theta\n953=iota\n954=kappa\n955=lambda\n956=mu\n957=nu\n958=xi\n959=omicron\n960=pi\n961=rho\n962=sigmaf\n963=sigma\n964=tau\n965=upsilon\n966=phi\n967=chi\n968=psi\n969=omega\n977=thetasym\n978=upsih\n982=piv\n8226=bull\n8230=hellip\n8242=prime\n8243=Prime\n8254=oline\n8260=frasl\n8472=weierp\n8465=image\n8476=real\n8482=trade\n8501=alefsym\n8592=larr\n8593=uarr\n8594=rarr\n8595=darr\n8596=harr\n8629=crarr\n8656=lArr\n8657=uArr\n8658=rArr\n8659=dArr\n8660=hArr\n8704=forall\n8706=part\n8707=exist\n8709=empty\n8711=nabla\n8712=isin\n8713=notin\n8715=ni\n8719=prod\n8721=sum\n8722=minus\n8727=lowast\n8730=radic\n8733=prop\n8734=infin\n8736=ang\n8743=and\n8744=or\n8745=cap\n8746=cup\n8747=int\n8756=there4\n8764=sim\n8773=cong\n8776=asymp\n8800=ne\n8801=equiv\n8804=le\n8805=ge\n8834=sub\n8835=sup\n8836=nsub\n8838=sube\n8839=supe\n8853=oplus\n8855=otimes\n8869=perp\n8901=sdot\n8968=lceil\n8969=rceil\n8970=lfloor\n8971=rfloor\n9001=lang\n9002=rang\n9674=loz\n9824=spades\n9827=clubs\n9829=hearts\n9830=diams\n\n34=quot\n38=amp\n39=#39\n60=lt\n62=gt\n338=OElig\n339=oelig\n352=Scaron\n353=scaron\n376=Yuml\n710=circ\n732=tilde\n8194=ensp\n8195=emsp\n8201=thinsp\n8204=zwnj\n8205=zwj\n8206=lrm\n8207=rlm\n8211=ndash\n8212=mdash\n8216=lsquo\n8217=rsquo\n8218=sbquo\n8220=ldquo\n8221=rdquo\n8222=bdquo\n8224=dagger\n8225=Dagger\n8240=permil\n8249=lsaquo\n8250=rsaquo\n8364=euro";
            for (String keyValueString : keys = chars.split("\n")) {
                if (keyValueString.trim().isEmpty()) continue;
                String[] keyValue = keyValueString.split("=");
                int referredChar = Integer.parseInt(keyValue[0]);
                int index = referredChar < 1000 ? referredChar : referredChar - 7000;
                this.characterToEntityReferenceMap[index] = '&' + keyValue[1] + ';';
                this.entityReferenceToCharacterMap.put(keyValue[1], Character.valueOf((char)referredChar));
            }
        }

        String convertToReference(char character, String encoding) {
            if (encoding.startsWith("UTF-")) {
                switch (character) {
                    case 60: {
                        return "&lt;";
                    }
                    case 62: {
                        return "&gt;";
                    }
                    case 34: {
                        return "&quot;";
                    }
                    case 38: {
                        return "&amp;";
                    }
                    case 39: {
                        return "&#39;";
                    }
                }
            } else if (character < 1000 || character >= 8000 && character < 10000) {
                int index = character < 1000 ? character : character - 7000;
                return this.characterToEntityReferenceMap[index];
            }
            return null;
        }

        char convertToCharacter(String entityReference) {
            Character referredCharacter = this.entityReferenceToCharacterMap.get(entityReference);
            if (referredCharacter != null) {
                return referredCharacter.charValue();
            }
            return '\uffff';
        }
    }

    private static class HtmlCharacterEntityDecoder {
        private static final int MAX_REFERENCE_SIZE = 10;
        private final HtmlCharacterEntityReferences characterEntityReferences;
        private final String originalMessage;
        private final StringBuilder decodedMessage;
        private int currentPosition = 0;
        private int nextPotentialReferencePosition = -1;
        private int nextSemicolonPosition = -2;

        HtmlCharacterEntityDecoder(HtmlCharacterEntityReferences characterEntityReferences, String original) {
            this.characterEntityReferences = characterEntityReferences;
            this.originalMessage = original;
            this.decodedMessage = new StringBuilder(original.length());
        }

        String decode() {
            while (this.currentPosition < this.originalMessage.length()) {
                this.findNextPotentialReference(this.currentPosition);
                this.copyCharactersTillPotentialReference();
                this.processPossibleReference();
            }
            return this.decodedMessage.toString();
        }

        private void findNextPotentialReference(int startPosition) {
            this.nextPotentialReferencePosition = Math.max(startPosition, this.nextSemicolonPosition - 10);
            do {
                boolean isPotentialReference;
                this.nextPotentialReferencePosition = this.originalMessage.indexOf(38, this.nextPotentialReferencePosition);
                if (this.nextSemicolonPosition != -1 && this.nextSemicolonPosition < this.nextPotentialReferencePosition) {
                    this.nextSemicolonPosition = this.originalMessage.indexOf(59, this.nextPotentialReferencePosition + 1);
                }
                boolean bl = isPotentialReference = this.nextPotentialReferencePosition != -1 && this.nextSemicolonPosition != -1 && this.nextPotentialReferencePosition - this.nextSemicolonPosition < 10;
                if (isPotentialReference || this.nextPotentialReferencePosition == -1) break;
                if (this.nextSemicolonPosition != -1) {
                    ++this.nextPotentialReferencePosition;
                    continue;
                }
                this.nextPotentialReferencePosition = -1;
            } while (this.nextPotentialReferencePosition != -1);
        }

        private void copyCharactersTillPotentialReference() {
            if (this.nextPotentialReferencePosition != this.currentPosition) {
                int skipUntilIndex;
                int n = skipUntilIndex = this.nextPotentialReferencePosition != -1 ? this.nextPotentialReferencePosition : this.originalMessage.length();
                if (skipUntilIndex - this.currentPosition > 3) {
                    this.decodedMessage.append(this.originalMessage, this.currentPosition, skipUntilIndex);
                    this.currentPosition = skipUntilIndex;
                } else {
                    while (this.currentPosition < skipUntilIndex) {
                        this.decodedMessage.append(this.originalMessage.charAt(this.currentPosition++));
                    }
                }
            }
        }

        private void processPossibleReference() {
            if (this.nextPotentialReferencePosition != -1) {
                boolean wasProcessable;
                boolean isNumberedReference = this.originalMessage.charAt(this.currentPosition + 1) == '#';
                boolean bl = wasProcessable = isNumberedReference ? this.processNumberedReference() : this.processNamedReference();
                if (wasProcessable) {
                    this.currentPosition = this.nextSemicolonPosition + 1;
                } else {
                    char currentChar = this.originalMessage.charAt(this.currentPosition);
                    this.decodedMessage.append(currentChar);
                    ++this.currentPosition;
                }
            }
        }

        private boolean processNumberedReference() {
            char referenceChar = this.originalMessage.charAt(this.nextPotentialReferencePosition + 2);
            boolean isHexNumberedReference = referenceChar == 'x' || referenceChar == 'X';
            try {
                int value = !isHexNumberedReference ? Integer.parseInt(this.getReferenceSubstring(2)) : Integer.parseInt(this.getReferenceSubstring(3), 16);
                this.decodedMessage.append((char)value);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }

        private boolean processNamedReference() {
            String referenceName = this.getReferenceSubstring(1);
            char mappedCharacter = this.characterEntityReferences.convertToCharacter(referenceName);
            if (mappedCharacter != '\uffff') {
                this.decodedMessage.append(mappedCharacter);
                return true;
            }
            return false;
        }

        private String getReferenceSubstring(int referenceOffset) {
            return this.originalMessage.substring(this.nextPotentialReferencePosition + referenceOffset, this.nextSemicolonPosition);
        }
    }
}

