/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils.persian;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class LetterConverterUtility {
    private static final String ENGLISH_NUM = "0123456789";
    private static final String PERSIAN_NUM = "\u06f0\u06f1\u06f2\u06f3\u06f4\u06f5\u06f6\u06f7\u06f8\u06f9";
    private static final String ARABIC_NUM = "\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669";
    private static final String ARABIC_CHR = "\u0643\u0626\u064a\u0649\u0624";
    private static final String PERSIAN_CHR = "\u06a9\u06cc\u06cc\u06cc\u0648";
    private static final String PERSIAN_ALL = "\u06a9\u06cc\u06cc\u06cc\u06480123456789";
    private static final String ARABIC_ALL = "\u0643\u0626\u064a\u0649\u0624\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669";
    private static final String[] digit1 = new String[]{"\u0635\u0641\u0631", "\u06cc\u06a9", "\u062f\u0648", "\u0633\u0647", "\u0686\u0647\u0627\u0631", "\u067e\u0646\u062c", "\u0634\u0634", "\u0647\u0641\u062a", "\u0647\u0634\u062a", "\u0646\u0647"};
    private static final String[] digit1_5 = new String[]{"\u06cc\u0627\u0632\u062f\u0647", "\u062f\u0648\u0627\u0632\u062f\u0647", "\u0633\u06cc\u0632\u062f\u0647", "\u0686\u0647\u0627\u0631\u062f\u0647", "\u067e\u0627\u0646\u0632\u062f\u0647", "\u0634\u0627\u0646\u0632\u062f\u0647", "\u0647\u0641\u062f\u0647", "\u0647\u062c\u062f\u0647", "\u0646\u0648\u0632\u062f\u0647"};
    private static final String[] digit2 = new String[]{"\u062f\u0647", "\u0628\u06cc\u0633\u062a", "\u0633\u06cc", "\u0686\u0647\u0644", "\u067e\u0646\u062c\u0627\u0647", "\u0634\u0635\u062a", "\u0647\u0641\u062a\u0627\u062f", "\u0647\u0634\u062a\u0627\u062f", "\u0646\u0648\u062f"};
    private static final String[] digit3 = new String[]{"\u06cc\u06a9\u0635\u062f", "\u062f\u0648\u06cc\u0633\u062a", "\u0633\u06cc\u0635\u062f", "\u0686\u0647\u0627\u0631\u0635\u062f", "\u067e\u0627\u0646\u0635\u062f", "\u0634\u0634\u0635\u062f", "\u0647\u0641\u062a\u0635\u062f", "\u0647\u0634\u062a\u0635\u062f", "\u0646\u0647\u0635\u062f"};
    private static final String[] steps = new String[]{"\u0647\u0632\u0627\u0631", "\u0645\u06cc\u0644\u06cc\u0648\u0646", "\u0645\u06cc\u0644\u06cc\u0627\u0631\u062f", "\u062a\u0631\u06cc\u0644\u06cc\u0648\u0646", "\u06a9\u0627\u062f\u0631\u06cc\u0644\u06cc\u0648\u0646", "\u06a9\u0648\u06cc\u0646\u062a\u0631\u06cc\u0644\u06cc\u0648\u0646", "\u0633\u06a9\u0633\u062a\u0631\u06cc\u0644\u06cc\u0648\u0646", "\u0633\u067e\u062a\u0631\u06cc\u0644\u06cc\u0648\u0646", "\u0627\u06a9\u062a\u0631\u06cc\u0644\u06cc\u0648\u0646", "\u0646\u0648\u0646\u06cc\u0644\u06cc\u0648\u0646", "\u062f\u0633\u06cc\u0644\u06cc\u0648\u0646"};

    private LetterConverterUtility() {
    }

    public static String convertArabicCharacters(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        for (int j = 0; j < str.length(); ++j) {
            char c = str.charAt(j);
            int i = ARABIC_ALL.indexOf(c);
            if (i == -1) continue;
            str = str.replace(c, PERSIAN_ALL.charAt(i));
        }
        return str;
    }

    public static String convertFarsiNumbersToEnglish(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        for (int j = 0; j < str.length(); ++j) {
            char c = str.charAt(j);
            int i = PERSIAN_NUM.indexOf(c);
            if (i == -1) continue;
            str = str.replace(c, ENGLISH_NUM.charAt(i));
        }
        return str;
    }

    public static String convertEnglishNumbersToFarsi(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        for (int j = 0; j < str.length(); ++j) {
            char c = str.charAt(j);
            int i = ENGLISH_NUM.indexOf(c);
            if (i == -1) continue;
            str = str.replace(c, PERSIAN_NUM.charAt(i));
        }
        return str;
    }

    private static String commaSeparatedInternal(String amount) {
        StringBuilder sb = new StringBuilder();
        int len = amount.length();
        for (int i = 0; i < len; ++i) {
            sb.append(amount.charAt(len - 1 - i));
            if ((i + 1) % 3 != 0 || i >= len - 1) continue;
            sb.append(',');
        }
        return sb.reverse().toString();
    }

    public static String commaSeparated(String amount) {
        return LetterConverterUtility.convertEnglishNumbersToFarsi(LetterConverterUtility.commaSeparatedInternal(amount));
    }

    private static List<String> groupToWords(int group) {
        int d3 = (int)Math.floor((double)group / 100.0);
        int d2 = (int)Math.floor((double)(group - d3 * 100) / 10.0);
        int d1 = group - d3 * 100 - d2 * 10;
        ArrayList<String> groupArray = new ArrayList<String>();
        if (d3 != 0) {
            groupArray.add(digit3[d3 - 1]);
        }
        if (d2 == 1 && d1 != 0) {
            groupArray.add(digit1_5[d1 - 1]);
        } else if (d2 != 0 && d1 == 0) {
            groupArray.add(digit2[d2 - 1]);
        } else if (d2 != 0 || d1 != 0) {
            if (d2 == 0) {
                groupArray.add(digit1[d1]);
            } else {
                groupArray.add(digit2[d2 - 1]);
                groupArray.add(digit1[d1]);
            }
        }
        return !groupArray.isEmpty() ? groupArray : null;
    }

    public static String convertDigitToFarsiLetter(long number) {
        List<String> parts = LetterConverterUtility.convertDigitToFarsiLetterParts(Math.abs(number), " ");
        return String.join((CharSequence)" ", parts);
    }

    public static String convertDigitToFarsiLetterRial(long number) {
        boolean isNegative = false;
        if (number < 0L) {
            number *= -1L;
            isNegative = true;
        }
        List<String> parts = LetterConverterUtility.convertDigitToFarsiLetterParts(number, " \u0648 ");
        return (isNegative ? "\u0645\u0646\u0641\u06cc " : "") + String.join((CharSequence)" \u0648 ", parts) + " \u0631\u06cc\u0627\u0644";
    }

    public static List<String> convertDigitToFarsiLetterParts(long number, String delimiter) {
        String formated = LetterConverterUtility.commaSeparatedInternal(String.valueOf(number));
        String[] groups = formated.split(",");
        int len = groups.length;
        ArrayList<String> parts = new ArrayList<String>();
        for (int step = 0; step < len; ++step) {
            int group = Integer.parseInt(groups[step]);
            List<String> groupWords = LetterConverterUtility.groupToWords(group);
            if (groupWords == null) continue;
            StringBuilder part = new StringBuilder();
            part.append(String.join((CharSequence)delimiter, groupWords));
            if (len - step - 1 > 0) {
                part.append(' ');
                part.append(steps[len - step - 2]);
            }
            parts.add(String.valueOf(part));
        }
        return parts;
    }
}

