/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.jackson.converter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import lombok.Generated;
import org.bardframework.commons.utils.persian.LetterConverterUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalPersianCharacterDeserializer
extends JsonDeserializer<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NormalPersianCharacterDeserializer.class);

    public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        try {
            if (jsonParser.getValueAsString() != null) {
                return LetterConverterUtility.convertArabicCharacters(jsonParser.getValueAsString());
            }
        }
        catch (Exception e) {
            log.error("error when normal '{}' to english number", jsonParser.getCurrentValue());
            log.debug("exception details:", (Throwable)e);
        }
        return null;
    }
}

