/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils.persian;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class IranianNationalNoUtils {
    private static final Set<Long> nationalNoBlackList = new HashSet<Long>(List.of(Long.valueOf("0123456789"), Long.valueOf("1111111111"), Long.valueOf("2222222222"), Long.valueOf("3333333333"), Long.valueOf("4444444444"), Long.valueOf("5555555555"), Long.valueOf("6666666666"), Long.valueOf("7777777777"), Long.valueOf("8888888888"), Long.valueOf("9999999999")));

    private IranianNationalNoUtils() {
    }

    public static boolean checkNationalNo(long nationalNo) {
        int i;
        if (nationalNo < 10000000L || nationalNoBlackList.contains(nationalNo)) {
            return false;
        }
        String temp = String.format("%010d", nationalNo);
        int sum = 0;
        for (i = 0; i < 9; ++i) {
            sum += Integer.parseInt(temp.substring(i, i + 1)) * (10 - i);
        }
        return Integer.parseInt(temp.substring(i, i + 1)) == ((sum %= 11) < 2 ? sum : 11 - sum);
    }
}

