/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.jackson.converter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import org.bardframework.commons.utils.persian.LetterConverterUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArabicToPersianDeserializer
extends JsonDeserializer<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArabicToPersianDeserializer.class);

    public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        try {
            return LetterConverterUtility.convertArabicCharacters(jsonParser.getValueAsString());
        }
        catch (Exception e) {
            LOGGER.info("error when converting StringJalaliDate '{}' to LocalDate.", jsonParser.getCurrentValue());
            LOGGER.debug("exception details:", (Throwable)e);
            return null;
        }
    }
}

