/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.spring.boot;

import jakarta.servlet.Filter;
import java.util.List;
import lombok.Generated;
import org.bardframework.commons.web.cors.CorsFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

@ConfigurationProperties(prefix="bard.web.cors")
public class CorsConfiguration {
    private List<String> mapping;
    private List<String> allowedOrigins;
    private List<String> allowedMethods;
    private List<String> allowedHeaders;
    private List<String> exposedHeaders;
    private boolean allowCredentials;
    private int maxAgeSecond;

    @ConditionalOnProperty(value={"bard.web.cors.enabled"}, havingValue="true")
    @Bean
    public FilterRegistrationBean<CorsFilter> corsFilterRegistrationBean() {
        CorsFilter corsFilter = new CorsFilter(this.mapping, this.allowedOrigins, this.allowedMethods, this.allowedHeaders, this.exposedHeaders, this.allowCredentials, this.maxAgeSecond);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)corsFilter, new ServletRegistrationBean[0]);
        registrationBean.setOrder(-2147483647);
        return registrationBean;
    }

    @Generated
    public List<String> getMapping() {
        return this.mapping;
    }

    @Generated
    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    @Generated
    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    @Generated
    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    @Generated
    public List<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    @Generated
    public boolean isAllowCredentials() {
        return this.allowCredentials;
    }

    @Generated
    public int getMaxAgeSecond() {
        return this.maxAgeSecond;
    }

    @Generated
    public void setMapping(List<String> mapping) {
        this.mapping = mapping;
    }

    @Generated
    public void setAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    @Generated
    public void setAllowedMethods(List<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    @Generated
    public void setAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    @Generated
    public void setExposedHeaders(List<String> exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
    }

    @Generated
    public void setAllowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    @Generated
    public void setMaxAgeSecond(int maxAgeSecond) {
        this.maxAgeSecond = maxAgeSecond;
    }
}

