/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.spring.boot;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.utils.CharsetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ConfigsConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigsConfiguration.class);
    private static final String CLASS_PATH_KEY = "java.class.path";
    private static final String SEPARATOR_KEY = "path.separator";
    private static final Set<String> SENSITIVE_KEY_PARTS = new HashSet<String>(List.of("password", "credential", "secret", "token"));
    private static final Set<String> NOT_LOG_KEYS = new HashSet<String>(Collections.singletonList("java.class.path"));

    private static void append(StringBuilder configs, String key, String value) {
        configs.append(key);
        configs.append(":\n\t");
        configs.append(value);
        configs.append("\n");
    }

    @Bean
    ConfigsLogger configsLogger(Environment environment, @Qualifier(value="appConfigs") Map<String, String> appConfigs, @Qualifier(value="i18nResources") List<Resource> resources) {
        return new ConfigsLogger(environment, resources, appConfigs);
    }

    @Bean(value={"i18nResources"})
    List<Resource> i18nResources(Environment environment) throws IOException {
        PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.addAll(List.of(patternResolver.getResources("classpath*:**/**/application.properties")));
        resources.addAll(List.of(patternResolver.getResources("classpath*:**/**-config.properties")));
        for (String profile : environment.getActiveProfiles()) {
            resources.addAll(List.of(patternResolver.getResources("classpath*:**/**/application-" + profile + ".properties")));
        }
        return resources;
    }

    @Bean
    BardPropertySourcesPlaceholderConfigurer placeHolderConfigurer(@Qualifier(value="i18nResources") List<Resource> resources) {
        BardPropertySourcesPlaceholderConfigurer propertyConfigurer = new BardPropertySourcesPlaceholderConfigurer();
        propertyConfigurer.setLocations(resources.toArray(new Resource[0]));
        return propertyConfigurer;
    }

    @Bean(value={"appConfigs"})
    Map<String, String> appConfigs(Environment environment, BardPropertySourcesPlaceholderConfigurer configurer) throws IOException {
        MutablePropertySources sources = ((AbstractEnvironment)environment).getPropertySources();
        HashMap<String, String> configs = new HashMap<String, String>();
        StreamSupport.stream(sources.spliterator(), false).filter(propertySource -> propertySource instanceof EnumerablePropertySource).map(propertySource -> ((EnumerablePropertySource)propertySource).getPropertyNames()).flatMap(Arrays::stream).forEach(property -> configs.put((String)property, environment.getProperty(property)));
        for (Map.Entry<Object, Object> entry : configurer.mergeProperties().entrySet()) {
            configs.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return configs;
    }

    private static class ConfigsLogger {
        private final Environment environment;
        private final List<Resource> resources;
        private final Map<String, String> appConfigs;

        private ConfigsLogger(Environment environment, List<Resource> resources, Map<String, String> appConfigs) {
            this.environment = environment;
            this.resources = resources;
            this.appConfigs = appConfigs;
        }

        @PostConstruct
        public void logConfigs() {
            StringBuilder aggregatedConfig = new StringBuilder();
            ConfigsConfiguration.append(aggregatedConfig, "Active profiles", Arrays.toString(this.environment.getActiveProfiles()));
            String classpath = this.environment.getProperty(ConfigsConfiguration.CLASS_PATH_KEY);
            String separator = this.environment.getProperty(ConfigsConfiguration.SEPARATOR_KEY);
            ConfigsConfiguration.append(aggregatedConfig, "Config Files", this.resources.stream().map(Object::toString).collect(Collectors.joining("\n\t")));
            if (StringUtils.isNotBlank((CharSequence)classpath) && StringUtils.isNotBlank((CharSequence)separator)) {
                ConfigsConfiguration.append(aggregatedConfig, ConfigsConfiguration.CLASS_PATH_KEY, Arrays.stream(classpath.split(separator)).map(Object::toString).collect(Collectors.joining("\n\t")));
            } else {
                log.info("classpath[{}] or separator[{}] is not valid", (Object)classpath, (Object)separator);
                ConfigsConfiguration.append(aggregatedConfig, ConfigsConfiguration.CLASS_PATH_KEY, classpath);
            }
            ConfigsConfiguration.append(aggregatedConfig, "DefaultCharset", String.valueOf(CharsetUtils.getDefaultCharset()));
            ConfigsConfiguration.append(aggregatedConfig, "DefaultLocale", String.valueOf(CharsetUtils.getDefaultLocale()));
            ConfigsConfiguration.append(aggregatedConfig, "DefaultEncoding", String.valueOf(CharsetUtils.getDefaultEncoding()));
            this.appConfigs.keySet().stream().sorted().forEach(property -> {
                if (!this.getNotLogKeys().contains(property.toLowerCase())) {
                    if (this.getSensitiveKeyParts().stream().anyMatch(sensitiveKey -> property.toLowerCase().contains((CharSequence)sensitiveKey))) {
                        ConfigsConfiguration.append(aggregatedConfig, property, "*****");
                    } else {
                        ConfigsConfiguration.append(aggregatedConfig, property, this.appConfigs.get(property));
                    }
                }
            });
            log.info("\n\n====== configuration ======\n{}====== configuration ======\n", (Object)aggregatedConfig);
        }

        protected Set<String> getSensitiveKeyParts() {
            return SENSITIVE_KEY_PARTS;
        }

        protected Set<String> getNotLogKeys() {
            return NOT_LOG_KEYS;
        }
    }

    public static class BardPropertySourcesPlaceholderConfigurer
    extends PropertySourcesPlaceholderConfigurer {
        public Properties mergeProperties() throws IOException {
            return super.mergeProperties();
        }
    }
}

