/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.security.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.bardframework.commons.security.context.SecurityContextManager;
import org.bardframework.commons.security.token.AuthenticationAbstract;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SecurityContextFilter<T extends AuthenticationAbstract<?>>
implements Filter {
    private final SecurityContextManager<T, ?> securityContextManager;

    public SecurityContextFilter(@Autowired SecurityContextManager<T, ?> securityContextManager) {
        this.securityContextManager = securityContextManager;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.securityContextManager.setSecurityContext((HttpServletRequest)request, (HttpServletResponse)response);
        chain.doFilter(request, response);
    }
}

