/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.security.token.manager;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bardframework.commons.security.token.manager.Token;
import org.bardframework.commons.security.token.manager.TokenManager;
import org.springframework.scheduling.annotation.Scheduled;

public abstract class InMemoryTokenManager<T extends Token>
implements TokenManager<T> {
    private final Map<String, T> tokens = new ConcurrentHashMap<String, T>();
    private long tokenExpirationMills = 432000000L;

    @Override
    public String put(T token) {
        String tokenId = UUID.randomUUID().toString() + "-" + System.nanoTime();
        this.tokens.put(tokenId, token);
        return tokenId;
    }

    @Override
    public boolean remove(String tokenId) {
        return this.tokens.remove(tokenId) != null;
    }

    @Override
    public T get(String tokenId) {
        Token tokenInfo = (Token)this.tokens.get(tokenId);
        if (null == tokenInfo) {
            return null;
        }
        if (tokenInfo.isExpired(this.tokenExpirationMills)) {
            this.remove(tokenId);
            return null;
        }
        return (T)tokenInfo;
    }

    public void setTokenExpirationMills(long tokenExpirationMills) {
        this.tokenExpirationMills = tokenExpirationMills;
    }

    @Scheduled(cron="${token.manager.cleaner.cron:0 */1 * * * *}")
    public void cleanTempFolder() {
        this.tokens.entrySet().parallelStream().filter(entry -> ((Token)entry.getValue()).isExpired(this.tokenExpirationMills)).forEach(entry -> {
            Token cfr_ignored_0 = (Token)this.tokens.remove(entry.getKey());
        });
    }
}

