/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.redis;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.bardframework.commons.redis.DataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class DataManagerRedisImpl
implements DataManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataManagerRedisImpl.class);
    private static final String ERROR_WRITE_VALUE = "error writing value";
    protected final RedisTemplate<String, Object> redisTemplate;
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());

    public DataManagerRedisImpl(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public boolean isExist(String key) {
        return Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)key));
    }

    @Override
    public void putAsJson(String key, Object value, Duration expiration) {
        try {
            String valueString = this.objectMapper.writeValueAsString(value);
            this.redisTemplate.opsForValue().set((Object)key, (Object)valueString, expiration);
        }
        catch (Exception e) {
            log.error("error putting [{}] to redis", value);
            throw new IllegalArgumentException(ERROR_WRITE_VALUE, e);
        }
    }

    @Override
    public void put(String key, String value, Duration expiration) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, (Object)value, expiration);
        }
        catch (Exception e) {
            log.error("error putting [{}] to redis", (Object)key);
            throw new IllegalArgumentException(ERROR_WRITE_VALUE, e);
        }
    }

    @Override
    public String get(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public <T> T getFromJson(String tokenId, Class<T> clazz) {
        try {
            String valueString = (String)this.redisTemplate.opsForValue().get((Object)tokenId);
            if (null == valueString) {
                return null;
            }
            return (T)this.objectMapper.readValue(valueString, clazz);
        }
        catch (Exception e) {
            log.error("error getting value with key [{}] from redis server, and converting to [{}]", (Object)tokenId, clazz);
            throw new IllegalArgumentException("error getting value from server", e);
        }
    }

    @Override
    public boolean remove(String key) {
        return Boolean.TRUE.equals(this.redisTemplate.delete((Object)key));
    }

    @Override
    public void addToSet(String key, String value, Duration expiration) {
        try {
            this.redisTemplate.opsForSet().add((Object)key, new Object[]{value});
            this.redisTemplate.persist((Object)key);
            this.redisTemplate.expire((Object)key, expiration);
        }
        catch (Exception e) {
            log.error("error putting [{}] to redis", (Object)key);
            throw new IllegalArgumentException(ERROR_WRITE_VALUE, e);
        }
    }

    @Override
    public Set<String> getFromSet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            log.error("error reading [{}] to redis", (Object)key);
            throw new IllegalArgumentException(ERROR_WRITE_VALUE, e);
        }
    }

    @Override
    public void removeFromSet(String key, String value, Duration expiration) {
        try {
            this.redisTemplate.opsForSet().remove((Object)key, new Object[]{value});
            this.redisTemplate.persist((Object)key);
            this.redisTemplate.expire((Object)key, expiration);
        }
        catch (Exception e) {
            log.error("error removing set value of [{}] from redis", (Object)key);
            throw new IllegalArgumentException(ERROR_WRITE_VALUE, e);
        }
    }

    @Override
    public void putAsMap(String key, Map<?, ?> map, Duration expiration) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            this.redisTemplate.persist((Object)key);
            this.redisTemplate.expire((Object)key, expiration);
        }
        catch (Exception e) {
            log.error("error putting [{}] to redis", (Object)key);
            throw new IllegalArgumentException(ERROR_WRITE_VALUE, e);
        }
    }

    @Override
    public Object getFromMap(String key, String hashKey) {
        try {
            return this.redisTemplate.opsForHash().get((Object)key, (Object)hashKey);
        }
        catch (Exception e) {
            log.error("error getting value with key [{}] from redis server", (Object)key);
            throw new IllegalArgumentException("error getting value from server", e);
        }
    }

    @Override
    public void removeFromMap(String userId, String topic, Duration expiration) {
        try {
            this.redisTemplate.opsForHash().delete((Object)userId, new Object[]{topic});
            this.redisTemplate.expire((Object)userId, expiration);
        }
        catch (Exception e) {
            log.error("error removing map key of [{}] from redis", (Object)userId);
            throw new IllegalArgumentException(ERROR_WRITE_VALUE, e);
        }
    }
}

