/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.jackson.converter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class LongToLocalDateConverter
extends JsonDeserializer<LocalDate>
implements Converter<Long, LocalDate> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LongToLocalDateConverter.class);

    public LocalDate deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        try {
            return this.convert(jsonParser.getValueAsLong());
        }
        catch (Exception e) {
            log.info("error when converting StringLocalDateJalali '{}' to LocalDate.", jsonParser.getCurrentValue());
            log.debug("exception details:", (Throwable)e);
            return null;
        }
    }

    public LocalDate convert(Long mills) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(mills), ZoneOffset.UTC).toLocalDate();
    }
}

