/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.jackson.converter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneOffset;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class LocalDateToLongConverter
extends JsonSerializer<LocalDate>
implements Converter<LocalDate, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalDateToLongConverter.class);

    public void serialize(LocalDate date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        try {
            jsonGenerator.writeNumber(this.convert(date).longValue());
        }
        catch (Exception e) {
            log.error("error when toModel local date time '{}' to jalali date time string:", (Object)date, (Object)e);
            jsonGenerator.writeNull();
        }
    }

    public Long convert(LocalDate source) {
        return source.atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
    }
}

