/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.jackson.converter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class LocalDateTimeToLongConverter
extends JsonSerializer<LocalDateTime>
implements Converter<LocalDateTime, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalDateTimeToLongConverter.class);

    public void serialize(LocalDateTime dateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        try {
            jsonGenerator.writeNumber(this.convert(dateTime).longValue());
        }
        catch (Exception e) {
            log.error("error when toModel local date time '{}' to mills", (Object)dateTime, (Object)e);
            jsonGenerator.writeNull();
        }
    }

    public Long convert(LocalDateTime value) {
        return value.toInstant(ZoneOffset.UTC).toEpochMilli();
    }
}

