/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.jackson.converter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;

public class JsonRloRemoverHtmlScapeDeserializer
extends JsonDeserializer<String> {
    private static final char RLO = '\u202e';
    private static final char EMPTY = '\u0000';

    public static String removeRlo(String value) {
        return value.replace('\u202e', '\u0000');
    }

    public String deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        String rawValue = parser.getValueAsString();
        if (null == rawValue) {
            return null;
        }
        return JsonRloRemoverHtmlScapeDeserializer.removeRlo(rawValue).replace('\u202e', '\u0000');
    }
}

