/*
 * Decompiled with CFR 0.152.
 */
package org.bakeneko.rabbitmq.rpc.factory;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bakeneko.rabbitmq.rpc.generator.ExchangeGenerator;
import org.bakeneko.rabbitmq.rpc.generator.RoutingKeyGenerator;
import org.springframework.amqp.core.MessagePostProcessor;

public class RabbitClientMetadata {
    private final ExchangeGenerator exchangeGenerator;
    private final RoutingKeyGenerator routingKeyGenerator;
    private final MessagePostProcessor messagePostProcessor;
    private final Integer payloadParameterIndex;
    private final Integer headerMapParameterIndex;
    private final Map<String, Integer> headerParameterIndexByName;

    public RabbitClientMetadata(ExchangeGenerator exchangeGenerator, RoutingKeyGenerator routingKeyGenerator, MessagePostProcessor messagePostProcessor, Integer payloadParameterIndex, Integer headerMapParameterIndex, Map<String, Integer> headerParameterIndexByName) {
        this.exchangeGenerator = exchangeGenerator != null ? exchangeGenerator : (target, method, params) -> null;
        this.routingKeyGenerator = routingKeyGenerator != null ? routingKeyGenerator : (target, method, params) -> null;
        this.messagePostProcessor = messagePostProcessor != null ? messagePostProcessor : message -> message;
        this.payloadParameterIndex = payloadParameterIndex;
        this.headerMapParameterIndex = headerMapParameterIndex;
        this.headerParameterIndexByName = headerParameterIndexByName;
    }

    public ExchangeGenerator getExchangeGenerator() {
        return this.exchangeGenerator;
    }

    public RoutingKeyGenerator getRoutingKeyGenerator() {
        return this.routingKeyGenerator;
    }

    public MessagePostProcessor getMessagePostProcessor() {
        return this.messagePostProcessor;
    }

    public Object getPayload(Object[] args) {
        return this.payloadParameterIndex != null ? args[this.payloadParameterIndex] : null;
    }

    public Map<String, Object> getHeaders(Object[] args) {
        HashMap<String, Object> allHeaders = new HashMap<String, Object>();
        if (this.headerMapParameterIndex != null) {
            Map headerMap = (Map)args[this.headerMapParameterIndex];
            allHeaders.putAll(headerMap);
        }
        Map<String, Object> singleHeaders = this.headerParameterIndexByName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> args[(Integer)entry.getValue()]));
        allHeaders.putAll(singleHeaders);
        return allHeaders;
    }
}

