/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.JointDef;
import com.badlogic.gdx.physics.box2d.JointEdge;
import com.badlogic.gdx.physics.box2d.World;

public abstract class Joint {
    protected long addr;
    private final World world;
    private final float[] tmp = new float[2];
    private Object userData;
    protected JointEdge jointEdgeA;
    protected JointEdge jointEdgeB;
    private final Vector2 anchorA = new Vector2();
    private final Vector2 anchorB = new Vector2();
    private final Vector2 reactionForce = new Vector2();
    private static final float[] out = new float[2];

    protected Joint(World world, long addr) {
        this.world = world;
        this.addr = addr;
    }

    public JointDef.JointType getType() {
        int type = this.jniGetType(this.addr);
        if (type > 0 && type < JointDef.JointType.valueTypes.length) {
            return JointDef.JointType.valueTypes[type];
        }
        return JointDef.JointType.Unknown;
    }

    private native int jniGetType(long var1);

    public Body getBodyA() {
        return (Body)this.world.bodies.get(this.jniGetBodyA(this.addr));
    }

    private native long jniGetBodyA(long var1);

    public Body getBodyB() {
        return (Body)this.world.bodies.get(this.jniGetBodyB(this.addr));
    }

    private native long jniGetBodyB(long var1);

    public Vector2 getAnchorA() {
        this.jniGetAnchorA(this.addr, this.tmp);
        this.anchorA.x = this.tmp[0];
        this.anchorA.y = this.tmp[1];
        return this.anchorA;
    }

    private native void jniGetAnchorA(long var1, float[] var3);

    public Vector2 getAnchorB() {
        this.jniGetAnchorB(this.addr, this.tmp);
        this.anchorB.x = this.tmp[0];
        this.anchorB.y = this.tmp[1];
        return this.anchorB;
    }

    private native void jniGetAnchorB(long var1, float[] var3);

    public boolean getCollideConnected() {
        return this.jniGetCollideConnected(this.addr);
    }

    private native boolean jniGetCollideConnected(long var1);

    public Vector2 getReactionForce(float inv_dt) {
        this.jniGetReactionForce(this.addr, inv_dt, this.tmp);
        this.reactionForce.x = this.tmp[0];
        this.reactionForce.y = this.tmp[1];
        return this.reactionForce;
    }

    private native void jniGetReactionForce(long var1, float var3, float[] var4);

    public float getReactionTorque(float inv_dt) {
        return this.jniGetReactionTorque(this.addr, inv_dt);
    }

    private native float jniGetReactionTorque(long var1, float var3);

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public boolean isEnabled() {
        return this.jniIsEnabled(this.addr);
    }

    private native boolean jniIsEnabled(long var1);

    public static StiffnessAndDamping linearStiffness(float frequencyHertz, float dampingRatio, Body bodyA, Body bodyB) {
        Joint.jniLinearStiffness(frequencyHertz, dampingRatio, bodyA.addr, bodyB.addr, out);
        return new StiffnessAndDamping(out[0], out[1]);
    }

    private static native void jniLinearStiffness(float var0, float var1, long var2, long var4, float[] var6);

    public static StiffnessAndDamping angularStiffness(float frequencyHertz, float dampingRatio, Body bodyA, Body bodyB) {
        Joint.jniAngularStiffness(frequencyHertz, dampingRatio, bodyA.addr, bodyB.addr, out);
        return new StiffnessAndDamping(out[0], out[1]);
    }

    private static native void jniAngularStiffness(float var0, float var1, long var2, long var4, float[] var6);

    public static class StiffnessAndDamping {
        public final float stiffness;
        public final float damping;

        public StiffnessAndDamping(float stiffness, float damping) {
            this.stiffness = stiffness;
            this.damping = damping;
        }
    }
}

