/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.JniUtil;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.physics.box2d.Transform;

public class ChainShape
extends Shape {
    boolean isLooped = false;
    private static final float[] verts = new float[2];

    public ChainShape() {
        this.addr = this.newChainShape();
    }

    private native long newChainShape();

    ChainShape(long addr) {
        this.addr = addr;
    }

    @Override
    public Shape.Type getType() {
        return Shape.Type.Chain;
    }

    public void clear() {
        this.jniClear(this.addr);
    }

    private native void jniClear(long var1);

    public void createLoop(float[] vertices) {
        this.jniCreateLoop(this.addr, vertices, 0, vertices.length / 2);
        this.isLooped = true;
    }

    public void createLoop(float[] vertices, int offset, int length) {
        this.jniCreateLoop(this.addr, vertices, offset, length / 2);
        this.isLooped = true;
    }

    public void createLoop(Vector2[] vertices) {
        float[] verts = JniUtil.arrayOfVec2IntoFloat(vertices);
        this.jniCreateLoop(this.addr, verts, 0, verts.length / 2);
        this.isLooped = true;
    }

    private native void jniCreateLoop(long var1, float[] var3, int var4, int var5);

    public void createChain(Vector2[] vertices, Vector2 prevVert, Vector2 nextVert) {
        float[] verts = JniUtil.arrayOfVec2IntoFloat(vertices);
        this.jniCreateChain(this.addr, verts, 0, vertices.length, prevVert.x, prevVert.y, nextVert.x, nextVert.y);
        this.isLooped = false;
    }

    private native void jniCreateChain(long var1, float[] var3, int var4, int var5, float var6, float var7, float var8, float var9);

    public int getVertexCount() {
        return this.jniGetVertexCount(this.addr);
    }

    private native int jniGetVertexCount(long var1);

    public void getVertex(int ix, Vector2 vertex) {
        this.jniGetVertex(this.addr, ix, verts);
        vertex.x = verts[0];
        vertex.y = verts[1];
    }

    private native void jniGetVertex(long var1, int var3, float[] var4);

    @Override
    public boolean testPoint(Transform transform, Vector2 point) {
        return false;
    }

    public boolean isLooped() {
        return this.isLooped;
    }
}

