/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.spring;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.function.Supplier;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.extensions.mongo.MongoTemplate;
import org.bson.Document;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.MongoDatabaseUtils;

public class SpringMongoTemplate
implements MongoTemplate {
    private final Supplier<MongoDatabase> databaseSupplier;
    private final String trackingTokensCollectionName;
    private final String domainEventsCollectionName;
    private final String snapshotEventsCollectionName;
    private final String sagasCollectionName;
    private final String deadLetterCollectionName;

    protected SpringMongoTemplate(Builder builder) {
        builder.validate();
        this.databaseSupplier = builder.databaseSupplier();
        this.trackingTokensCollectionName = builder.trackingTokensCollectionName;
        this.domainEventsCollectionName = builder.domainEventsCollectionName;
        this.snapshotEventsCollectionName = builder.snapshotEventsCollectionName;
        this.sagasCollectionName = builder.sagasCollectionName;
        this.deadLetterCollectionName = builder.deadLetterCollectionName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MongoCollection<Document> trackingTokensCollection() {
        return this.databaseSupplier.get().getCollection(this.trackingTokensCollectionName);
    }

    public MongoCollection<Document> eventCollection() {
        return this.databaseSupplier.get().getCollection(this.domainEventsCollectionName);
    }

    public MongoCollection<Document> snapshotCollection() {
        return this.databaseSupplier.get().getCollection(this.snapshotEventsCollectionName);
    }

    public MongoCollection<Document> sagaCollection() {
        return this.databaseSupplier.get().getCollection(this.sagasCollectionName);
    }

    public MongoCollection<Document> deadLetterCollection() {
        return this.databaseSupplier.get().getCollection(this.deadLetterCollectionName);
    }

    public static class Builder {
        private MongoDatabaseFactory factory;
        private String databaseName = null;
        private String trackingTokensCollectionName = "trackingtokens";
        private String domainEventsCollectionName = "domainevents";
        private String snapshotEventsCollectionName = "snapshotevents";
        private String sagasCollectionName = "sagas";
        private String deadLetterCollectionName = "deadletters";

        public Builder factory(MongoDatabaseFactory factory) {
            BuilderUtils.assertNonNull((Object)factory, (String)"The factory may not be null");
            this.factory = factory;
            return this;
        }

        public Builder databaseName(String databaseName) {
            BuilderUtils.assertNonEmpty((String)databaseName, (String)"The databaseName may not be empty");
            this.databaseName = databaseName;
            return this;
        }

        public Builder trackingTokensCollectionName(String trackingTokensCollectionName) {
            BuilderUtils.assertNonEmpty((String)trackingTokensCollectionName, (String)"The trackingTokensCollectionName may not be empty");
            this.trackingTokensCollectionName = trackingTokensCollectionName;
            return this;
        }

        public Builder domainEventsCollectionName(String domainEventsCollectionName) {
            BuilderUtils.assertNonEmpty((String)domainEventsCollectionName, (String)"The domainEventsCollectionName may not be empty");
            this.domainEventsCollectionName = domainEventsCollectionName;
            return this;
        }

        public Builder snapshotEventsCollectionName(String snapshotEventsCollectionName) {
            BuilderUtils.assertNonEmpty((String)snapshotEventsCollectionName, (String)"The snapshotEventsCollectionName may not be empty");
            this.snapshotEventsCollectionName = snapshotEventsCollectionName;
            return this;
        }

        public Builder sagasCollectionName(String sagasCollectionName) {
            BuilderUtils.assertNonEmpty((String)sagasCollectionName, (String)"The sagasCollectionName may not be empty");
            this.sagasCollectionName = sagasCollectionName;
            return this;
        }

        public Builder deadLetterCollectionName(String deadLetterCollectionName) {
            BuilderUtils.assertNonEmpty((String)deadLetterCollectionName, (String)"The deadLetterCollectionName may not be empty");
            this.deadLetterCollectionName = deadLetterCollectionName;
            return this;
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull((Object)this.factory, (String)"The MongoDatabaseFactory is a hard requirement and should be provided");
        }

        private Supplier<MongoDatabase> databaseSupplier() {
            return () -> MongoDatabaseUtils.getDatabase((String)this.databaseName, (MongoDatabaseFactory)this.factory);
        }

        public SpringMongoTemplate build() {
            return new SpringMongoTemplate(this);
        }
    }
}

