/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.springboot.autoconfig;

import java.util.Optional;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.EventProcessingModule;
import org.axonframework.extensions.mongo.MongoTemplate;
import org.axonframework.extensions.mongo.eventhandling.deadletter.MongoSequencedDeadLetterQueue;
import org.axonframework.extensions.mongo.springboot.AxonMongoProperties;
import org.axonframework.extensions.mongo.springboot.autoconfig.MongoAutoConfiguration;
import org.axonframework.serialization.Serializer;
import org.axonframework.springboot.EventProcessorProperties;
import org.axonframework.springboot.autoconfig.EventProcessingAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@AutoConfiguration
@EnableConfigurationProperties(value={AxonMongoProperties.class, EventProcessorProperties.class})
@AutoConfigureAfter(value={MongoAutoConfiguration.class, EventProcessingAutoConfiguration.class})
public class MongoDeadLetterProviderAutoConfiguration {
    private final AxonMongoProperties axonMongoProperties;
    private final EventProcessorProperties eventProcessorProperties;

    public MongoDeadLetterProviderAutoConfiguration(AxonMongoProperties axonMongoProperties, EventProcessorProperties eventProcessorProperties) {
        this.axonMongoProperties = axonMongoProperties;
        this.eventProcessorProperties = eventProcessorProperties;
    }

    @Autowired
    void registerDeadLetterProvider(EventProcessingModule processingModule, MongoTemplate mongoTemplate, Serializer serializer, TransactionManager transactionManager) {
        if (!this.axonMongoProperties.getEventHandling().isDlqEnabled()) {
            return;
        }
        processingModule.registerDeadLetterQueueProvider(processingGroup -> {
            if (this.dlqEnabled((String)processingGroup)) {
                return configuration -> MongoSequencedDeadLetterQueue.builder().processingGroup(processingGroup).mongoTemplate(mongoTemplate).transactionManager(transactionManager).serializer(serializer).build();
            }
            return null;
        });
    }

    private boolean dlqEnabled(String processingGroup) {
        return Optional.ofNullable(this.eventProcessorProperties.getProcessors().get(processingGroup)).map(processorSettings -> processorSettings.getDlq().isEnabled()).orElse(false);
    }
}

