/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.springboot.autoconfig;

import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.Configuration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.extensions.mongo.MongoTemplate;
import org.axonframework.extensions.mongo.eventhandling.saga.repository.MongoSagaStore;
import org.axonframework.extensions.mongo.eventsourcing.eventstore.MongoEventStorageEngine;
import org.axonframework.extensions.mongo.eventsourcing.eventstore.StorageStrategy;
import org.axonframework.extensions.mongo.eventsourcing.eventstore.documentperevent.DocumentPerEventStorageStrategy;
import org.axonframework.extensions.mongo.eventsourcing.tokenstore.MongoTokenStore;
import org.axonframework.extensions.mongo.spring.SpringMongoTemplate;
import org.axonframework.extensions.mongo.spring.SpringMongoTransactionManager;
import org.axonframework.extensions.mongo.springboot.AxonMongoProperties;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.springboot.TokenStoreProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.MongoTransactionManager;

@AutoConfiguration
@EnableConfigurationProperties(value={AxonMongoProperties.class, TokenStoreProperties.class})
@AutoConfigureAfter(name={"org.axonframework.springboot.autoconfig.TransactionAutoConfiguration", "org.axonframework.springboot.autoconfig.JdbcAutoConfiguration"})
public class MongoAutoConfiguration {
    private final AxonMongoProperties axonMongoProperties;
    private final TokenStoreProperties tokenStoreProperties;

    public MongoAutoConfiguration(AxonMongoProperties axonMongoProperties, TokenStoreProperties tokenStoreProperties) {
        this.axonMongoProperties = axonMongoProperties;
        this.tokenStoreProperties = tokenStoreProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public MongoTransactionManager mongoTransactionManager(MongoDatabaseFactory factory) {
        return new MongoTransactionManager(factory, TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).build());
    }

    @Bean
    @ConditionalOnMissingBean
    public TransactionManager transactionManager(MongoTransactionManager manager) {
        return new SpringMongoTransactionManager(manager);
    }

    @Bean
    @ConditionalOnMissingBean
    public MongoTemplate axonMongoTemplate(MongoDatabaseFactory factory) {
        String databaseName = this.axonMongoProperties.getDatabaseName();
        if (Objects.isNull(databaseName)) {
            return SpringMongoTemplate.builder().factory(factory).build();
        }
        return SpringMongoTemplate.builder().factory(factory).databaseName(databaseName).build();
    }

    @Bean(value={"tokenStore"})
    @ConditionalOnMissingBean(value={TokenStore.class})
    @ConditionalOnProperty(value={"axon.mongo.token-store.enabled"}, matchIfMissing=true)
    public TokenStore tokenStore(MongoTemplate mongoTemplate, TransactionManager transactionManager, Serializer serializer) {
        return MongoTokenStore.builder().mongoTemplate(mongoTemplate).transactionManager(transactionManager).serializer(serializer).claimTimeout((TemporalAmount)this.tokenStoreProperties.getClaimTimeout()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"axon.mongo.event-store.enabled"})
    public StorageStrategy storageStrategy() {
        return new DocumentPerEventStorageStrategy();
    }

    @Bean
    @ConditionalOnMissingBean(value={EventStorageEngine.class, EventBus.class})
    @ConditionalOnProperty(value={"axon.mongo.event-store.enabled"})
    public EventStorageEngine eventStorageEngine(MongoTemplate mongoTemplate, TransactionManager transactionManager, Serializer snapshotSerializer, @Qualifier(value="eventSerializer") Serializer serializer, StorageStrategy storageStrategy, Configuration configuration) {
        return MongoEventStorageEngine.builder().mongoTemplate(mongoTemplate).transactionManager(transactionManager).snapshotSerializer(snapshotSerializer).eventSerializer(serializer).storageStrategy(storageStrategy).upcasterChain((EventUpcaster)configuration.upcasterChain()).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={SagaStore.class})
    @ConditionalOnProperty(value={"axon.mongo.saga-store.enabled"}, matchIfMissing=true)
    public MongoSagaStore sagaStore(MongoTemplate mongoTemplate, TransactionManager transactionManager, Serializer serializer) {
        return MongoSagaStore.builder().mongoTemplate(mongoTemplate).transactionManager(transactionManager).serializer(serializer).build();
    }
}

