/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Optional;
import org.axonframework.common.Priority;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.spring.SpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@Priority(value=-1073741824)
public class SpringBeanParameterResolverFactory
implements ParameterResolverFactory,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(SpringBeanParameterResolverFactory.class);
    private ApplicationContext applicationContext;

    public SpringBeanParameterResolverFactory() {
    }

    public SpringBeanParameterResolverFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ParameterResolver createInstance(Executable executable, Parameter[] parameters, int parameterIndex) {
        if (this.applicationContext == null) {
            return null;
        }
        Class<?> parameterType = parameters[parameterIndex].getType();
        Map beansFound = this.applicationContext.getBeansOfType(parameterType);
        if (beansFound.isEmpty()) {
            return null;
        }
        if (beansFound.size() > 1) {
            Optional<ParameterResolver> resolver;
            AutowireCapableBeanFactory beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
            if (beanFactory instanceof ConfigurableListableBeanFactory && (resolver = this.findQualifiedBean(beansFound, (ConfigurableListableBeanFactory)beanFactory, parameters, parameterIndex)).isPresent()) {
                return resolver.get();
            }
            if (logger.isWarnEnabled()) {
                logger.warn("{} beans of type {} found, but none was marked as primary and parameter lacks @Qualifier. Ignoring this parameter.", (Object)beansFound.size(), (Object)parameterType.getSimpleName());
            }
            return null;
        }
        return new SpringBeanParameterResolver(this.applicationContext.getAutowireCapableBeanFactory(), (String)beansFound.keySet().iterator().next());
    }

    private Optional<ParameterResolver> findQualifiedBean(Map<String, ?> beansFound, ConfigurableListableBeanFactory clBeanFactory, Parameter[] parameters, int parameterIndex) {
        Parameter parameter = parameters[parameterIndex];
        Optional qualifier = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)parameter, Qualifier.class);
        if (qualifier.isPresent()) {
            for (Map.Entry<String, ?> bean : beansFound.entrySet()) {
                if (!SpringUtils.isQualifierMatch(bean.getKey(), clBeanFactory, (String)((Map)qualifier.get()).get("qualifier"))) continue;
                return Optional.of(new SpringBeanParameterResolver((AutowireCapableBeanFactory)clBeanFactory, bean.getKey()));
            }
        }
        for (Map.Entry<String, ?> bean : beansFound.entrySet()) {
            if (!clBeanFactory.containsBeanDefinition(bean.getKey()) || !clBeanFactory.getBeanDefinition(bean.getKey()).isPrimary()) continue;
            return Optional.of(new SpringBeanParameterResolver((AutowireCapableBeanFactory)clBeanFactory, bean.getKey()));
        }
        return Optional.empty();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private static class SpringBeanParameterResolver
    implements ParameterResolver<Object> {
        private final AutowireCapableBeanFactory beanFactory;
        private final String beanName;

        public SpringBeanParameterResolver(AutowireCapableBeanFactory beanFactory, String beanName) {
            this.beanFactory = beanFactory;
            this.beanName = beanName;
        }

        public Object resolveParameterValue(Message message) {
            return this.beanFactory.getBean(this.beanName);
        }

        public boolean matches(Message message) {
            return true;
        }
    }
}

