/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import java.util.Map;
import javax.annotation.Nonnull;
import org.axonframework.messaging.AbstractMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializationException;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public class SerializedMessage<T>
extends AbstractMessage<T> {
    private static final long serialVersionUID = 8079093289710229594L;
    private final LazyDeserializingObject<MetaData> metaData;
    private final LazyDeserializingObject<T> payload;

    public SerializedMessage(String identifier, SerializedObject<?> serializedPayload, SerializedObject<?> serializedMetaData, Serializer serializer) {
        this(identifier, new LazyDeserializingObject(serializedPayload, serializer), new LazyDeserializingObject<MetaData>(serializedMetaData, serializer));
    }

    public SerializedMessage(String identifier, LazyDeserializingObject<T> payload, LazyDeserializingObject<MetaData> metaData) {
        super(identifier);
        this.metaData = metaData;
        this.payload = payload;
    }

    private SerializedMessage(SerializedMessage<T> message, LazyDeserializingObject<MetaData> newMetaData) {
        this(message.getIdentifier(), message.payload, newMetaData);
    }

    @Override
    public T getPayload() {
        try {
            return this.payload.getObject();
        }
        catch (SerializationException e) {
            throw new SerializationException("Error while deserializing payload of message " + this.getIdentifier(), e);
        }
    }

    @Override
    public MetaData getMetaData() {
        try {
            return this.metaData.getObject();
        }
        catch (SerializationException e) {
            throw new SerializationException("Error while deserializing meta data of message " + this.getIdentifier(), e);
        }
    }

    @Override
    public Class<T> getPayloadType() {
        return this.payload.getType();
    }

    @Override
    protected SerializedMessage<T> withMetaData(MetaData metaData) {
        if (this.getMetaData().equals(metaData)) {
            return this;
        }
        return new SerializedMessage<T>(this, new LazyDeserializingObject<MetaData>(metaData));
    }

    @Override
    public SerializedMessage<T> withMetaData(@Nonnull Map<String, ?> metaData) {
        return (SerializedMessage)super.withMetaData(metaData);
    }

    @Override
    public SerializedMessage<T> andMetaData(@Nonnull Map<String, ?> metaData) {
        return (SerializedMessage)super.andMetaData(metaData);
    }

    @Override
    public <R> SerializedObject<R> serializePayload(Serializer serializer, Class<R> expectedRepresentation) {
        if (serializer.equals(this.payload.getSerializer())) {
            return serializer.getConverter().convert(this.payload.getSerializedObject(), expectedRepresentation);
        }
        return serializer.serialize(this.payload.getObject(), expectedRepresentation);
    }

    @Override
    public <R> SerializedObject<R> serializeMetaData(Serializer serializer, Class<R> expectedRepresentation) {
        if (serializer.equals(this.metaData.getSerializer())) {
            return serializer.getConverter().convert(this.metaData.getSerializedObject(), expectedRepresentation);
        }
        return serializer.serialize(this.metaData.getObject(), expectedRepresentation);
    }

    public boolean isPayloadDeserialized() {
        return this.payload.isDeserialized();
    }

    public boolean isMetaDataDeserialized() {
        return this.metaData.isDeserialized();
    }

    protected Object writeReplace() {
        return new GenericMessage<T>(this.getIdentifier(), this.getPayload(), this.getMetaData());
    }
}

