/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.persistence.Column;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import javax.persistence.Basic;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.eventhandling.EventData;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.serialization.SerializedMetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;

@jakarta.persistence.MappedSuperclass
@MappedSuperclass
public abstract class AbstractEventEntry<T>
implements EventData<T> {
    @Column(nullable=false, unique=true)
    @javax.persistence.Column(nullable=false, unique=true)
    private String eventIdentifier;
    @jakarta.persistence.Basic(optional=false)
    @Basic(optional=false)
    private String timeStamp;
    @jakarta.persistence.Basic(optional=false)
    @Basic(optional=false)
    private String payloadType;
    @jakarta.persistence.Basic
    @Basic
    private String payloadRevision;
    @jakarta.persistence.Basic(optional=false)
    @jakarta.persistence.Lob
    @Column(length=10000)
    @Basic(optional=false)
    @Lob
    @javax.persistence.Column(length=10000)
    private T payload;
    @jakarta.persistence.Basic
    @jakarta.persistence.Lob
    @Column(length=10000)
    @Basic
    @Lob
    @javax.persistence.Column(length=10000)
    private T metaData;

    public AbstractEventEntry(EventMessage<?> eventMessage, Serializer serializer, Class<T> contentType) {
        SerializedObject<T> payload = eventMessage.serializePayload(serializer, contentType);
        SerializedObject<T> metaData = eventMessage.serializeMetaData(serializer, contentType);
        this.eventIdentifier = eventMessage.getIdentifier();
        this.payloadType = payload.getType().getName();
        this.payloadRevision = payload.getType().getRevision();
        this.payload = payload.getData();
        this.metaData = metaData.getData();
        this.timeStamp = DateTimeUtils.formatInstant(eventMessage.getTimestamp());
    }

    public AbstractEventEntry(String eventIdentifier, Object timestamp, String payloadType, String payloadRevision, T payload, T metaData) {
        this.eventIdentifier = eventIdentifier;
        this.timeStamp = timestamp instanceof TemporalAccessor ? DateTimeUtils.formatInstant((TemporalAccessor)timestamp) : timestamp.toString();
        this.payloadType = payloadType;
        this.payloadRevision = payloadRevision;
        this.payload = payload;
        this.metaData = metaData;
    }

    protected AbstractEventEntry() {
    }

    @Override
    public String getEventIdentifier() {
        return this.eventIdentifier;
    }

    @Override
    public Instant getTimestamp() {
        return DateTimeUtils.parseInstant(this.timeStamp);
    }

    @Override
    public SerializedObject<T> getMetaData() {
        return new SerializedMetaData<T>(this.metaData, this.metaData.getClass());
    }

    @Override
    public SerializedObject<T> getPayload() {
        return new SimpleSerializedObject<T>(this.payload, this.payload.getClass(), new SimpleSerializedType(this.payloadType, this.payloadRevision));
    }
}

