/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.deadletter;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.EnqueueDecision;

public class ShouldEnqueue<M extends Message<?>>
implements EnqueueDecision<M> {
    private final Throwable enqueueCause;
    private final Function<DeadLetter<? extends M>, MetaData> diagnosticsBuilder;

    public ShouldEnqueue() {
        this(null);
    }

    public ShouldEnqueue(Throwable enqueueCause) {
        this(enqueueCause, d -> MetaData.emptyInstance());
    }

    public ShouldEnqueue(Throwable enqueueCause, Function<DeadLetter<? extends M>, MetaData> diagnosticsBuilder) {
        this.enqueueCause = enqueueCause;
        this.diagnosticsBuilder = diagnosticsBuilder;
    }

    @Override
    public boolean shouldEnqueue() {
        return true;
    }

    @Override
    public Optional<Throwable> enqueueCause() {
        return Optional.ofNullable(this.enqueueCause);
    }

    @Override
    public DeadLetter<? extends M> withDiagnostics(DeadLetter<? extends M> letter) {
        return letter.withDiagnostics(this.diagnosticsBuilder.apply(letter));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShouldEnqueue that = (ShouldEnqueue)o;
        return Objects.equals(this.enqueueCause, that.enqueueCause);
    }

    public int hashCode() {
        return Objects.hash(this.enqueueCause);
    }

    public String toString() {
        return "ShouldEnqueue{enqueueCause=" + this.enqueueCause + '}';
    }
}

