/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.kafka.eventhandling.producer;

import org.axonframework.common.Assert;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.kafka.eventhandling.DefaultKafkaMessageConverter;
import org.axonframework.kafka.eventhandling.KafkaMessageConverter;
import org.axonframework.kafka.eventhandling.producer.ProducerFactory;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.xml.XStreamSerializer;

public class KafkaPublisherConfiguration<K, V> {
    private final SubscribableMessageSource<EventMessage<?>> messageSource;
    private final ProducerFactory<K, V> producerFactory;
    private final KafkaMessageConverter<K, V> messageConverter;
    private final MessageMonitor<? super EventMessage<?>> messageMonitor;
    private final String topic;
    private final long publisherAckTimeout;

    private KafkaPublisherConfiguration(Builder<K, V> builder) {
        this.messageSource = ((Builder)builder).messageSource;
        this.producerFactory = ((Builder)builder).producerFactory;
        this.messageConverter = ((Builder)builder).messageConverter;
        this.messageMonitor = ((Builder)builder).messageMonitor;
        this.topic = ((Builder)builder).topic;
        this.publisherAckTimeout = ((Builder)builder).publisherAckTimeout;
    }

    public SubscribableMessageSource<EventMessage<?>> getMessageSource() {
        return this.messageSource;
    }

    public ProducerFactory<K, V> getProducerFactory() {
        return this.producerFactory;
    }

    public KafkaMessageConverter<K, V> getMessageConverter() {
        return this.messageConverter;
    }

    public MessageMonitor<? super EventMessage<?>> getMessageMonitor() {
        return this.messageMonitor;
    }

    public String getTopic() {
        return this.topic;
    }

    public long getPublisherAckTimeout() {
        return this.publisherAckTimeout;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static final class Builder<K, V> {
        private SubscribableMessageSource<EventMessage<?>> messageSource;
        private ProducerFactory<K, V> producerFactory;
        private KafkaMessageConverter<K, V> messageConverter = new DefaultKafkaMessageConverter((Serializer)new XStreamSerializer());
        private MessageMonitor<? super EventMessage<?>> messageMonitor = NoOpMessageMonitor.instance();
        private String topic = "Axon.Events";
        private long publisherAckTimeout = 1000L;

        public Builder<K, V> withMessageSource(SubscribableMessageSource<EventMessage<?>> messageSource) {
            Assert.notNull(messageSource, () -> "Message source may not be null");
            this.messageSource = messageSource;
            return this;
        }

        public Builder<K, V> withProducerFactory(ProducerFactory<K, V> producerFactory) {
            Assert.notNull(producerFactory, () -> "Producer factory may not be null");
            this.producerFactory = producerFactory;
            return this;
        }

        public Builder<K, V> withMessageConverter(KafkaMessageConverter<K, V> messageConverter) {
            Assert.notNull(messageConverter, () -> "Message converter may not be null");
            this.messageConverter = messageConverter;
            return this;
        }

        public Builder<K, V> withMessageMonitor(MessageMonitor<? super EventMessage<?>> messageMonitor) {
            Assert.notNull(messageMonitor, () -> "Message monitor may not be null");
            this.messageMonitor = messageMonitor;
            return this;
        }

        public Builder<K, V> withTopic(String topic) {
            Assert.notNull((Object)topic, () -> "Topic may not be null");
            this.topic = topic;
            return this;
        }

        public Builder<K, V> withPublisherAckTimeout(long timeoutInMillis) {
            Assert.isTrue((timeoutInMillis >= 0L ? 1 : 0) != 0, () -> "Timeout may not be negative");
            this.publisherAckTimeout = timeoutInMillis;
            return this;
        }

        public KafkaPublisherConfiguration<K, V> build() {
            Assert.notNull(this.producerFactory, () -> "The publisher must be configured with a ProducerFactory");
            Assert.notNull(this.messageSource, () -> "The publisher must be configured with a MessageSource");
            return new KafkaPublisherConfiguration(this);
        }
    }
}

