/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.kafka.eventhandling.consumer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.axonframework.common.Assert;
import org.axonframework.eventsourcing.eventstore.TrackingToken;

public class KafkaTrackingToken
implements TrackingToken,
Serializable {
    private final Map<Integer, Long> partitionPositions;

    @JsonCreator
    public static KafkaTrackingToken newInstance(@JsonProperty(value="partitionPositions") Map<Integer, Long> partitionPositions) {
        return new KafkaTrackingToken(partitionPositions);
    }

    public static KafkaTrackingToken emptyToken() {
        return KafkaTrackingToken.newInstance(new HashMap<Integer, Long>());
    }

    private KafkaTrackingToken(Map<Integer, Long> partitionPositions) {
        this.partitionPositions = Collections.unmodifiableMap(new HashMap<Integer, Long>(partitionPositions));
    }

    public Map<Integer, Long> partitionPositions() {
        return this.partitionPositions;
    }

    public Collection<TopicPartition> partitions(String topic) {
        return this.partitionPositions.keySet().stream().map(i -> new TopicPartition(topic, i.intValue())).collect(Collectors.toList());
    }

    public static TopicPartition partition(String topic, int partitionNumber) {
        return new TopicPartition(topic, partitionNumber);
    }

    public KafkaTrackingToken advancedTo(int partition, long offset) {
        Assert.isTrue((partition >= 0 ? 1 : 0) != 0, () -> "Partition may not be negative");
        Assert.isTrue((offset >= 0L ? 1 : 0) != 0, () -> "Offset may not be negative");
        HashMap<Integer, Long> newPositions = new HashMap<Integer, Long>(this.partitionPositions);
        newPositions.put(partition, offset);
        return new KafkaTrackingToken(newPositions);
    }

    public TrackingToken lowerBound(TrackingToken other) {
        Assert.isTrue((boolean)(other instanceof KafkaTrackingToken), () -> "Incompatible token type provided.");
        KafkaTrackingToken otherToken = (KafkaTrackingToken)other;
        Map<Integer, Long> partitionsWithLowerBound = this.bounds(otherToken, Math::min);
        return new KafkaTrackingToken(partitionsWithLowerBound);
    }

    public TrackingToken upperBound(TrackingToken other) {
        Assert.isTrue((boolean)(other instanceof KafkaTrackingToken), () -> "Incompatible token type provided.");
        KafkaTrackingToken otherToken = (KafkaTrackingToken)other;
        Map<Integer, Long> partitionsWithUpperBound = this.bounds(otherToken, Math::max);
        return new KafkaTrackingToken(partitionsWithUpperBound);
    }

    public boolean covers(TrackingToken other) {
        Assert.isTrue((boolean)(other instanceof KafkaTrackingToken), () -> "Incompatible token type provided.");
        KafkaTrackingToken otherToken = (KafkaTrackingToken)other;
        long oldest = this.partitionPositions.values().stream().min(Comparator.naturalOrder()).orElse(0L);
        return otherToken.partitionPositions.keySet().stream().allMatch(k -> this.partitionPositions.containsKey(k) || otherToken.partitionPositions.get(k) < oldest);
    }

    public static boolean isEmpty(KafkaTrackingToken token) {
        return token == null || token.partitionPositions.isEmpty();
    }

    public static boolean isNotEmpty(KafkaTrackingToken token) {
        return !KafkaTrackingToken.isEmpty(token);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaTrackingToken that = (KafkaTrackingToken)o;
        return Objects.equals(this.partitionPositions, that.partitionPositions);
    }

    public int hashCode() {
        return Objects.hash(this.partitionPositions);
    }

    public String toString() {
        return "KafkaTrackingToken{partitionPositions=" + this.partitionPositions + '}';
    }

    private Map<Integer, Long> bounds(KafkaTrackingToken otherToken, BiFunction<Long, Long, Long> fxn) {
        HashMap<Integer, Long> intersection = new HashMap<Integer, Long>(this.partitionPositions);
        otherToken.partitionPositions.forEach(intersection::putIfAbsent);
        intersection.keySet().forEach(k -> {
            Long cfr_ignored_0 = (Long)intersection.put((Integer)k, (Long)fxn.apply(this.partitionPositions.getOrDefault(k, 0L), otherToken.partitionPositions.getOrDefault(k, 0L)));
        });
        return intersection;
    }
}

