/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.kafka.eventhandling.consumer;

import java.util.Collection;
import java.util.Collections;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.axonframework.kafka.eventhandling.consumer.KafkaTrackingToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerUtil {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerUtil.class);

    private ConsumerUtil() {
    }

    public static void seek(final String topic, final Consumer consumer, final KafkaTrackingToken token) {
        consumer.subscribe(Collections.singletonList(topic), new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                if (KafkaTrackingToken.isNotEmpty(token)) {
                    logger.debug("Seeking consumer to {}", (Object)token);
                    token.partitionPositions().forEach((partition, offset) -> consumer.seek(KafkaTrackingToken.partition(topic, partition), offset + 1L));
                }
            }
        });
    }
}

