/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.EventStreamUtils;
import org.axonframework.eventsourcing.eventstore.ConcatenatingDomainEventStream;
import org.axonframework.eventsourcing.eventstore.FilteringDomainEventStream;
import org.axonframework.eventsourcing.eventstore.IteratorBackedDomainEventStream;

public interface DomainEventStream
extends Iterator<DomainEventMessage<?>> {
    public static DomainEventStream of(Stream<? extends DomainEventMessage<?>> stream, final Supplier<Long> sequenceNumberSupplier) {
        Objects.requireNonNull(stream);
        return new IteratorBackedDomainEventStream(stream.iterator()){

            @Override
            public Long getLastSequenceNumber() {
                return (Long)sequenceNumberSupplier.get();
            }
        };
    }

    public static DomainEventStream of(Stream<? extends DomainEventMessage<?>> stream) {
        return new IteratorBackedDomainEventStream(stream.iterator());
    }

    public static DomainEventStream empty() {
        return DomainEventStream.of(new DomainEventMessage[0]);
    }

    public static DomainEventStream of(final DomainEventMessage<?> event) {
        Objects.requireNonNull(event);
        return new DomainEventStream(){
            private boolean hasNext = true;

            @Override
            public DomainEventMessage<?> peek() {
                if (this.hasNext) {
                    return event;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public DomainEventMessage<?> next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return event;
                }
                throw new NoSuchElementException();
            }

            @Override
            public Long getLastSequenceNumber() {
                return event.getSequenceNumber();
            }
        };
    }

    public static DomainEventStream of(DomainEventMessage<?> ... events) {
        return DomainEventStream.of(Arrays.asList(events));
    }

    public static DomainEventStream of(List<? extends DomainEventMessage<?>> list) {
        return list.isEmpty() ? DomainEventStream.of(Stream.empty(), () -> null) : DomainEventStream.of(list.stream(), () -> list.isEmpty() ? null : Long.valueOf(((DomainEventMessage)list.get(list.size() - 1)).getSequenceNumber()));
    }

    public static DomainEventStream concat(DomainEventStream a, DomainEventStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        return new ConcatenatingDomainEventStream(a, b);
    }

    default public DomainEventStream filter(Predicate<? super DomainEventMessage<?>> filter) {
        Objects.requireNonNull(filter);
        return new FilteringDomainEventStream(this, filter);
    }

    @Override
    public boolean hasNext();

    @Override
    public DomainEventMessage<?> next();

    public DomainEventMessage<?> peek();

    public Long getLastSequenceNumber();

    @Override
    default public void remove() {
        throw new UnsupportedOperationException();
    }

    default public Stream<? extends DomainEventMessage<?>> asStream() {
        return EventStreamUtils.asStream(this);
    }
}

